/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc;

import bitronix.tm.resource.jdbc.BaseProxyHandlerClass;
import bitronix.tm.resource.jdbc.JdbcPooledConnection;
import bitronix.tm.resource.jdbc.JdbcResultSetHandle;
import bitronix.tm.utils.ClassLoaderUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcUncachedPreparedStatementHandle
extends BaseProxyHandlerClass {
    private final JdbcPooledConnection parentConnection;
    private final PreparedStatement delegate;

    public JdbcUncachedPreparedStatementHandle(PreparedStatement delegate, JdbcPooledConnection pooledConnection) {
        this.delegate = delegate;
        this.parentConnection = pooledConnection;
    }

    @Override
    public Object getProxiedDelegate() throws Exception {
        return this.delegate;
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.delegate.getClass());
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.delegate.getClass())) {
            return (T)this.delegate;
        }
        throw new SQLException(this.getClass().getName() + " is not a wrapper for " + iface);
    }

    public void close() throws SQLException {
        this.parentConnection.unregisterUncachedStatement(this.delegate);
        this.delegate.close();
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return (ResultSet)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new JdbcResultSetHandle(this.delegate.executeQuery(sql), this));
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return (ResultSet)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new JdbcResultSetHandle(this.delegate.getGeneratedKeys(), this));
    }

    public ResultSet getResultSet() throws SQLException {
        return (ResultSet)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new JdbcResultSetHandle(this.delegate.getResultSet(), this));
    }

    public ResultSet executeQuery() throws SQLException {
        return (ResultSet)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new JdbcResultSetHandle(this.delegate.executeQuery(), this));
    }

    public boolean equals(Object object) {
        InvocationHandler handler = Proxy.getInvocationHandler(object);
        return super.equals(handler);
    }
}

