/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.function;

import java.util.List;
import org.dashbuilder.dataset.engine.function.SumFunction;
import org.dashbuilder.dataset.group.AggregateFunctionType;

public class AverageFunction
extends SumFunction {
    @Override
    public AggregateFunctionType getType() {
        return AggregateFunctionType.AVERAGE;
    }

    @Override
    public Object aggregate(List values) {
        if (values == null || values.isEmpty()) {
            return 0.0;
        }
        double average = (Double)super.aggregate(values) / (double)values.size();
        return this.round(average, this.precission);
    }

    @Override
    public Object aggregate(List values, List<Integer> rows) {
        if (rows == null) {
            return this.aggregate(values);
        }
        if (rows.isEmpty()) {
            return 0.0;
        }
        if (values == null || values.isEmpty()) {
            return 0.0;
        }
        double average = (Double)super.aggregate(values, rows) / (double)rows.size();
        return this.round(average, this.precission);
    }
}

