/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.json;

import org.dashbuilder.json.JsonContext;
import org.dashbuilder.json.JsonType;
import org.dashbuilder.json.JsonValue;
import org.dashbuilder.json.JsonVisitor;

public class JsonBoolean
implements JsonValue {
    private boolean bool;

    public JsonBoolean(boolean bool) {
        this.bool = bool;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean asBoolean() {
        return this.getBoolean();
    }

    @Override
    public double asNumber() {
        return this.getBoolean() ? 1.0 : 0.0;
    }

    @Override
    public String asString() {
        return Boolean.toString(this.getBoolean());
    }

    public boolean getBoolean() {
        return this.bool;
    }

    @Override
    public JsonType getType() {
        return JsonType.BOOLEAN;
    }

    @Override
    public void traverse(JsonVisitor visitor, JsonContext ctx) {
        visitor.visit(this.getBoolean(), ctx);
    }

    @Override
    public String toJson() throws IllegalStateException {
        return String.valueOf(this.bool);
    }
}

