/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.json;

import org.dashbuilder.json.JsonContext;
import org.dashbuilder.json.JsonType;
import org.dashbuilder.json.JsonUtil;
import org.dashbuilder.json.JsonValue;
import org.dashbuilder.json.JsonVisitor;

public class JsonString
implements JsonValue {
    private String string;

    public JsonString(String string) {
        this.string = string;
    }

    @Override
    public boolean isEmpty() {
        return this.string == null;
    }

    @Override
    public boolean asBoolean() {
        return this.string != null && this.string.toLowerCase().equals("true");
    }

    @Override
    public double asNumber() {
        try {
            if (this.asString().isEmpty()) {
                return 0.0;
            }
            return Double.parseDouble(this.asString());
        }
        catch (NumberFormatException nfe) {
            return Double.NaN;
        }
    }

    @Override
    public String asString() {
        return this.getString();
    }

    public String getString() {
        return this.string;
    }

    @Override
    public JsonType getType() {
        return JsonType.STRING;
    }

    @Override
    public void traverse(JsonVisitor visitor, JsonContext ctx) {
        visitor.visit(this.getString(), ctx);
    }

    @Override
    public String toJson() throws IllegalStateException {
        return JsonUtil.quote(this.getString());
    }
}

