/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.json;

import java.util.HashSet;
import java.util.Set;
import org.dashbuilder.json.Json;
import org.dashbuilder.json.JsonArray;
import org.dashbuilder.json.JsonContext;
import org.dashbuilder.json.JsonException;
import org.dashbuilder.json.JsonObject;
import org.dashbuilder.json.JsonValue;
import org.dashbuilder.json.JsonVisitor;

public class JsonUtil {
    public static String escapeControlChars(String text) {
        StringBuilder toReturn = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (JsonUtil.isControlChar(c)) {
                toReturn.append(JsonUtil.escapeStringAsUnicode(String.valueOf(c)));
                continue;
            }
            toReturn.append(c);
        }
        return toReturn.toString();
    }

    public static <T extends JsonValue> T parse(String json) throws JsonException {
        return Json.instance().parse(json);
    }

    public static String quote(String value) {
        StringBuilder toReturn = new StringBuilder("\"");
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            String toAppend = String.valueOf(c);
            switch (c) {
                case '\b': {
                    toAppend = "\\b";
                    break;
                }
                case '\t': {
                    toAppend = "\\t";
                    break;
                }
                case '\n': {
                    toAppend = "\\n";
                    break;
                }
                case '\f': {
                    toAppend = "\\f";
                    break;
                }
                case '\r': {
                    toAppend = "\\r";
                    break;
                }
                case '\"': {
                    toAppend = "\\\"";
                    break;
                }
                case '\\': {
                    toAppend = "\\\\";
                    break;
                }
                default: {
                    if (!JsonUtil.isControlChar(c)) break;
                    toAppend = JsonUtil.escapeStringAsUnicode(String.valueOf(c));
                }
            }
            toReturn.append(toAppend);
        }
        toReturn.append("\"");
        return toReturn.toString();
    }

    public static String stringify(JsonValue jsonValue) {
        return JsonUtil.stringify(jsonValue, 0);
    }

    public static String stringify(JsonValue jsonValue, int spaces) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < spaces; ++i) {
            sb.append(' ');
        }
        return JsonUtil.stringify(jsonValue, sb.toString());
    }

    public static String stringify(JsonValue jsonValue, String indent) {
        StringBuilder sb = new StringBuilder();
        boolean isPretty = indent != null && !"".equals(indent);
        new StringifyJsonVisitor(indent, sb, isPretty).accept(jsonValue);
        return sb.toString();
    }

    private static String escapeStringAsUnicode(String match) {
        String hexValue = Integer.toString(match.charAt(0), 16);
        hexValue = hexValue.length() > 4 ? hexValue.substring(hexValue.length() - 4) : hexValue;
        return "\\u0000" + hexValue;
    }

    private static boolean isControlChar(char c) {
        return c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c == '\u00ad' || c == '\u070f' || c == '\u17b4' || c == '\u17b5' || c == '\ufeff' || c >= '\u0600' && c <= '\u0604' || c >= '\u200c' && c <= '\u200f' || c >= '\u2028' && c <= '\u202f' || c >= '\u2060' && c <= '\u206f' || c >= '\ufff0' && c <= '\uffff';
    }

    private static class StringifyJsonVisitor
    extends JsonVisitor {
        private String indentLevel;
        private Set<JsonValue> visited;
        private final String indent;
        private final StringBuilder sb;
        private final boolean pretty;

        public StringifyJsonVisitor(String indent, StringBuilder sb, boolean pretty) {
            this.indent = indent;
            this.sb = sb;
            this.pretty = pretty;
            this.indentLevel = "";
            this.visited = new HashSet<JsonValue>();
        }

        @Override
        public void endVisit(JsonArray array, JsonContext ctx) {
            if (this.pretty) {
                this.indentLevel = this.indentLevel.substring(0, this.indentLevel.length() - this.indent.length());
                this.sb.append('\n');
                this.sb.append(this.indentLevel);
            }
            this.sb.append("]");
            this.visited.remove(array);
        }

        @Override
        public void endVisit(JsonObject object, JsonContext ctx) {
            if (this.pretty) {
                this.indentLevel = this.indentLevel.substring(0, this.indentLevel.length() - this.indent.length());
                this.sb.append('\n');
                this.sb.append(this.indentLevel);
            }
            this.sb.append("}");
            this.visited.remove(object);
            assert (!this.visited.contains(object));
        }

        @Override
        public void visit(double number, JsonContext ctx) {
            this.sb.append(Double.isInfinite(number) ? "null" : this.format(number));
        }

        @Override
        public void visit(String string, JsonContext ctx) {
            this.sb.append(JsonUtil.quote(string));
        }

        @Override
        public void visit(boolean bool, JsonContext ctx) {
            this.sb.append(bool);
        }

        @Override
        public boolean visit(JsonArray array, JsonContext ctx) {
            this.checkCycle(array);
            this.sb.append("[");
            if (this.pretty) {
                this.sb.append('\n');
                this.indentLevel = this.indentLevel + this.indent;
                this.sb.append(this.indentLevel);
            }
            return true;
        }

        @Override
        public boolean visit(JsonObject object, JsonContext ctx) {
            this.checkCycle(object);
            this.sb.append("{");
            if (this.pretty) {
                this.sb.append('\n');
                this.indentLevel = this.indentLevel + this.indent;
                this.sb.append(this.indentLevel);
            }
            return true;
        }

        @Override
        public boolean visitIndex(int index, JsonContext ctx) {
            this.commaIfNotFirst(ctx);
            return true;
        }

        @Override
        public boolean visitKey(String key, JsonContext ctx) {
            if ("".equals(key)) {
                return true;
            }
            this.commaIfNotFirst(ctx);
            this.sb.append(JsonUtil.quote(key) + ":");
            if (this.pretty) {
                this.sb.append(' ');
            }
            return true;
        }

        @Override
        public void visitNull(JsonContext ctx) {
            this.sb.append("null");
        }

        private void checkCycle(JsonValue value) {
            if (this.visited.contains(value)) {
                throw new JsonException("Cycled detected during stringify");
            }
            this.visited.add(value);
        }

        private void commaIfNotFirst(JsonContext ctx) {
            if (!ctx.isFirst()) {
                this.sb.append(",");
                if (this.pretty) {
                    this.sb.append('\n');
                    this.sb.append(this.indentLevel);
                }
            }
        }

        private String format(double number) {
            String n = String.valueOf(number);
            if (n.endsWith(".0")) {
                n = n.substring(0, n.length() - 2);
            }
            return n;
        }
    }
}

