/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.wih;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.core.ClassObjectFilter;
import org.jbpm.casemgmt.api.CaseService;
import org.jbpm.casemgmt.api.dynamic.TaskSpecification;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.runtime.manager.impl.identity.UserDataServiceProvider;
import org.jbpm.services.api.service.ServiceRegistry;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.SLAViolatedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.process.CaseAssignment;
import org.kie.internal.runtime.Cacheable;
import org.kie.internal.task.api.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyOwnerSLAViolationListener
extends DefaultProcessEventListener
implements Cacheable {
    private static final Logger logger = LoggerFactory.getLogger(NotifyOwnerSLAViolationListener.class);
    private UserInfo userInfo = UserDataServiceProvider.getUserInfo();
    private String subject;
    private String body;
    private String template;

    public NotifyOwnerSLAViolationListener() {
    }

    public NotifyOwnerSLAViolationListener(String subject, String body, String template) {
        this.subject = subject;
        this.body = body;
        this.template = template;
    }

    public void afterSLAViolated(SLAViolatedEvent event) {
        CaseFileInstance caseFile = this.getCaseFile((KieSession)event.getKieRuntime());
        if (caseFile != null) {
            String caseId = ((WorkflowProcessInstanceImpl)event.getProcessInstance()).getCorrelationKey();
            if (caseFile.getCaseId().equals(caseId)) {
                try {
                    Collection adminAssignments = ((CaseAssignment)caseFile).getAssignments("owner");
                    String recipients = adminAssignments.stream().map(oe -> this.userInfo.getEmailForEntity(oe)).collect(Collectors.joining(";"));
                    logger.debug("Case instance {} has SLA violation, notifying owner", (Object)caseId);
                    CaseService caseService = (CaseService)ServiceRegistry.get().service("CaseService");
                    Map<String, Object> parameters = this.buildEmailParameters(recipients, caseId, event);
                    TaskSpecification taskSpec = caseService.newTaskSpec("Email", "SLA Violation for case " + caseId, parameters);
                    caseService.addDynamicTask(caseId, taskSpec);
                }
                catch (IllegalArgumentException e) {
                    logger.debug("There is no owner role defined in case instance {}, unable to notify SLA violation", (Object)caseId);
                }
            }
        }
    }

    protected CaseFileInstance getCaseFile(KieSession ksession) {
        Collection caseFiles = ksession.getObjects((ObjectFilter)new ClassObjectFilter(CaseFileInstance.class));
        if (caseFiles.size() == 0) {
            return null;
        }
        CaseFileInstance caseFile = (CaseFileInstance)caseFiles.iterator().next();
        return caseFile;
    }

    public void close() {
    }

    protected Map<String, Object> buildEmailParameters(String recipients, String caseId, SLAViolatedEvent event) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("To", recipients);
        parameters.put("Subject", this.subject == null ? "SLA Violation for case " + caseId : this.subject);
        parameters.put("Body", this.body == null ? "Service Level Agreement has been violated for case " + caseId : this.body);
        if (this.template != null) {
            parameters.put("Template", this.template);
        }
        return parameters;
    }
}

