/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.deadlines.notifications.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import org.jbpm.services.task.deadlines.NotificationListener;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.UserInfo;
import org.kie.internal.task.api.model.NotificationEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationListenerManager {
    public static final String KIE_LISTENER_EXCLUDE = "org.kie.jbpm.notification_listeners.exclude";
    public static final String KIE_LISTENER_INCLUDE = "org.kie.jbpm.notification_listeners.include";
    private static final Logger logger = LoggerFactory.getLogger(NotificationListenerManager.class);
    private static ServiceLoader<NotificationListener> listenersLoaded = ServiceLoader.load(NotificationListener.class);
    private static NotificationListenerManager INSTANCE = new NotificationListenerManager();
    private List<NotificationListener> listeners = new ArrayList<NotificationListener>();
    private Optional<List<String>> excludeLists;
    private Optional<List<String>> includeLists;

    public static Optional<List<String>> propertyToList(String propertyName) {
        String name = System.getProperty(propertyName);
        if (name == null) {
            return Optional.empty();
        }
        if (name.isEmpty()) {
            return Optional.of(Collections.emptyList());
        }
        return Optional.of(Arrays.asList(name.trim().split("\\s*,\\s*")));
    }

    private NotificationListenerManager() {
        this.reset();
    }

    public void reset() {
        this.excludeLists = NotificationListenerManager.propertyToList(KIE_LISTENER_EXCLUDE);
        this.includeLists = NotificationListenerManager.propertyToList(KIE_LISTENER_INCLUDE);
        this.listeners.clear();
        Predicate<String> predicate = this.createPredicate();
        for (NotificationListener listener : listenersLoaded) {
            if (!predicate.test(listener.getClass().getName())) continue;
            this.listeners.add(listener);
        }
    }

    private Predicate<String> createPredicate() {
        if (this.includeLists.isPresent()) {
            return e -> this.includeLists.get().contains(e);
        }
        if (this.excludeLists.isPresent()) {
            return e -> !this.excludeLists.get().contains(e);
        }
        return e -> true;
    }

    public void registerAdditionalNotificationListener(List<NotificationListener> additionalNotificationListener) {
        for (NotificationListener listener : additionalNotificationListener) {
            this.listeners.add(listener);
        }
    }

    public List<NotificationListener> getNotificationListeners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(TaskContext taskContext, NotificationEvent event, UserInfo userInfo) {
        IdentityProvider identityProvider = (IdentityProvider)taskContext.get("org.kie.internal.identity.IdentityProvider");
        if (identityProvider != null) {
            identityProvider.setContextIdentity(System.getProperty("org.jbpm.ht.admin.user", "Administrator"));
        }
        try {
            this.broadcast(event, userInfo);
        }
        finally {
            if (identityProvider != null) {
                identityProvider.removeContextIdentity();
            }
        }
    }

    public void broadcast(NotificationEvent event, UserInfo userInfo) {
        for (NotificationListener listener : this.listeners) {
            try {
                logger.debug("Sending notification {} to {} with params {}", new Object[]{event, listener, userInfo});
                listener.onNotification(event, userInfo);
            }
            catch (Exception e) {
                logger.warn("Exception encountered while notifying listener {} with event {} - error {}", new Object[]{listener, event, e.getMessage()});
            }
        }
    }

    public static NotificationListenerManager get() {
        return INSTANCE;
    }
}

