/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.common.rest.variant;

import java.math.BigDecimal;
import java.math.MathContext;
import org.kie.server.common.rest.variant.QualityValue;

public class VariantQuality {
    private QualityValue mediaTypeQualityValue = QualityValue.DEFAULT;
    private QualityValue matchCountQualityValue = QualityValue.DEFAULT;
    private QualityValue characterSetQualityValue = QualityValue.DEFAULT;
    private QualityValue encodingQualityValue = QualityValue.DEFAULT;
    private QualityValue languageQualityValue = QualityValue.DEFAULT;

    public void setMatchCountQualityValue(QualityValue value) {
        this.matchCountQualityValue = value == null ? QualityValue.DEFAULT : value;
    }

    public void setMediaTypeQualityValue(QualityValue value) {
        this.mediaTypeQualityValue = value == null ? QualityValue.DEFAULT : value;
    }

    public void setCharacterSetQualityValue(QualityValue value) {
        this.characterSetQualityValue = value == null ? QualityValue.DEFAULT : value;
    }

    public void setEncodingQualityValue(QualityValue value) {
        this.encodingQualityValue = value == null ? QualityValue.DEFAULT : value;
    }

    public void setLanguageQualityValue(QualityValue value) {
        this.languageQualityValue = value == null ? QualityValue.DEFAULT : value;
    }

    public BigDecimal getOverallQuality() {
        BigDecimal qt = BigDecimal.valueOf(this.mediaTypeQualityValue.intValue(), 3);
        BigDecimal qm = BigDecimal.valueOf(this.matchCountQualityValue.intValue(), 3);
        BigDecimal qc = BigDecimal.valueOf(this.characterSetQualityValue.intValue(), 3);
        BigDecimal qe = BigDecimal.valueOf(this.encodingQualityValue.intValue(), 3);
        BigDecimal ql = BigDecimal.valueOf(this.languageQualityValue.intValue(), 3);
        assert (qt.compareTo(BigDecimal.ZERO) >= 0 && qt.compareTo(BigDecimal.ONE) <= 0);
        assert (qm.compareTo(BigDecimal.ZERO) >= 0 && qm.compareTo(BigDecimal.ONE) <= 0);
        assert (qc.compareTo(BigDecimal.ZERO) >= 0 && qc.compareTo(BigDecimal.ONE) <= 0);
        assert (qe.compareTo(BigDecimal.ZERO) >= 0 && qe.compareTo(BigDecimal.ONE) <= 0);
        assert (ql.compareTo(BigDecimal.ZERO) >= 0 && ql.compareTo(BigDecimal.ONE) <= 0);
        BigDecimal result = qt;
        result = result.multiply(qm, MathContext.DECIMAL32);
        result = result.multiply(qc, MathContext.DECIMAL32);
        result = result.multiply(qe, MathContext.DECIMAL32);
        result = result.multiply(ql, MathContext.DECIMAL32);
        assert (result.compareTo(BigDecimal.ZERO) >= 0 && result.compareTo(BigDecimal.ONE) <= 0);
        long round5 = result.scaleByPowerOfTen(5).longValue();
        result = BigDecimal.valueOf(round5, 5);
        assert (result.compareTo(BigDecimal.ZERO) >= 0 && result.compareTo(BigDecimal.ONE) <= 0);
        return result;
    }
}

