/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.date;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.GroupStrategy;

public class DateUtils {
    public static final SimpleDateFormat FORMATTER_YEAR = new SimpleDateFormat("yyyy");
    public static final SimpleDateFormat FORMATTER_MONTH = new SimpleDateFormat("yyyy-MM");
    public static final SimpleDateFormat FORMATTER_DAY = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat FORMATTER_HOUR = new SimpleDateFormat("yyyy-MM-dd HH");
    public static final SimpleDateFormat FORMATTER_MINUTE = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static final SimpleDateFormat FORMATTER_SECOND = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String MONTH_START = "-M";
    private static final String MONTH_END = "-";
    private static final String DAY_START = "-D";
    private static final String DAY_END = " ";
    private static final String HOUR_START = " H";
    private static final String HOUR_END = ":";
    private static final String MINUTE_START = ":m";
    private static final String MINUTE_END = ":";
    private static final String SECOND_START = ":s";
    private static final String SECOND_END = ":";

    public static Date parseDate(DataColumn dateColumn, Object date) throws Exception {
        DateIntervalType type = DateIntervalType.getByName((String)dateColumn.getIntervalType());
        GroupStrategy strategy = dateColumn.getColumnGroup().getStrategy();
        return DateUtils.parseDate(type, strategy, date);
    }

    public static Date parseDate(DateIntervalType type, GroupStrategy strategy, Object date) throws Exception {
        if (date == null) {
            return null;
        }
        if (GroupStrategy.FIXED.equals((Object)strategy)) {
            Calendar c = GregorianCalendar.getInstance();
            if (DateIntervalType.SECOND.equals((Object)type)) {
                c.set(13, ((Number)date).intValue());
                return c.getTime();
            }
            if (DateIntervalType.MINUTE.equals((Object)type)) {
                c.set(12, ((Number)date).intValue());
                return c.getTime();
            }
            if (DateIntervalType.HOUR.equals((Object)type)) {
                c.set(10, ((Number)date).intValue());
                return c.getTime();
            }
            if (DateIntervalType.DAY.equals((Object)type)) {
                c.set(5, ((Number)date).intValue());
                return c.getTime();
            }
            if (DateIntervalType.MONTH.equals((Object)type)) {
                c.set(2, ((Number)date).intValue() - 1);
                c.set(5, 1);
                return c.getTime();
            }
            if (DateIntervalType.QUARTER.equals((Object)type)) {
                c.set(2, ((Number)date).intValue() - 1);
                c.set(5, 1);
                return c.getTime();
            }
            throw new IllegalArgumentException("Interval size '" + type + "' not supported for fixed date intervals. The only supported sizes are: " + StringUtils.join((Iterable)DateIntervalType.FIXED_INTERVALS_SUPPORTED, (String)","));
        }
        if (type.getIndex() <= DateIntervalType.SECOND.getIndex()) {
            return FORMATTER_SECOND.parse(date.toString());
        }
        if (type.getIndex() <= DateIntervalType.MINUTE.getIndex()) {
            return FORMATTER_MINUTE.parse(date.toString());
        }
        if (type.getIndex() <= DateIntervalType.HOUR.getIndex()) {
            return FORMATTER_HOUR.parse(date.toString());
        }
        if (type.getIndex() <= DateIntervalType.DAY.getIndex()) {
            return FORMATTER_DAY.parse(date.toString());
        }
        if (type.getIndex() <= DateIntervalType.QUARTER.getIndex()) {
            return FORMATTER_MONTH.parse(date.toString());
        }
        return FORMATTER_YEAR.parse(date.toString());
    }

    public static String ensureTwoDigits(String date, DateIntervalType intervalType) {
        String result = date;
        if (DateIntervalType.compare((DateIntervalType)intervalType, (DateIntervalType)DateIntervalType.MONTH) <= 0) {
            result = DateUtils.ensureTwoDigits(result, MONTH_START, MONTH_END);
        }
        if (DateIntervalType.compare((DateIntervalType)intervalType, (DateIntervalType)DateIntervalType.DAY) <= 0) {
            result = DateUtils.ensureTwoDigits(result, DAY_START, DAY_END);
        }
        if (DateIntervalType.compare((DateIntervalType)intervalType, (DateIntervalType)DateIntervalType.HOUR) <= 0) {
            result = DateUtils.ensureTwoDigits(result, HOUR_START, ":");
        }
        if (DateIntervalType.compare((DateIntervalType)intervalType, (DateIntervalType)DateIntervalType.MINUTE) <= 0) {
            result = DateUtils.ensureTwoDigits(result, MINUTE_START, ":");
        }
        if (DateIntervalType.compare((DateIntervalType)intervalType, (DateIntervalType)DateIntervalType.SECOND) <= 0) {
            result = DateUtils.ensureTwoDigits(result, SECOND_START, ":");
        }
        return result;
    }

    public static String ensureTwoDigits(String date, String symbolStart, String symbolEnd) {
        int start = date.indexOf(symbolStart);
        if (start == -1) {
            return date;
        }
        int digitStart = start + symbolStart.length();
        int end = date.indexOf(symbolEnd, digitStart);
        if (end == -1) {
            end = date.length();
        }
        StringBuilder out = new StringBuilder();
        out.append(date.substring(0, start)).append(symbolStart.charAt(0));
        if (end - digitStart == 1) {
            char digit = date.charAt(digitStart);
            out.append('0').append(digit);
            out.append(date.substring(digitStart + 1));
        } else {
            out.append(date.substring(digitStart));
        }
        return out.toString();
    }
}

