/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.commands.error;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.impl.jpa.ExecutionErrorInfo;
import org.kie.api.executor.Command;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.executor.Reoccurring;
import org.kie.internal.runtime.error.ExecutionErrorManager;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AutoAckErrorCommand
implements Command,
Reoccurring {
    private static final Logger logger = LoggerFactory.getLogger(AutoAckErrorCommand.class);
    private long nextScheduleTimeAdd = 86400000L;

    public Date getScheduleTime() {
        if (this.nextScheduleTimeAdd < 0L) {
            return null;
        }
        long current = System.currentTimeMillis();
        Date nextSchedule = new Date(current + this.nextScheduleTimeAdd);
        logger.debug("Next schedule for job {} is set to {}", (Object)this.getClass().getSimpleName(), (Object)nextSchedule);
        return nextSchedule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResults execute(CommandContext ctx) throws Exception {
        String nextRun;
        String singleRun;
        ExecutionResults executionResults = new ExecutionResults();
        String emfName = (String)ctx.getData("EmfName");
        if (emfName == null) {
            emfName = "org.jbpm.domain";
        }
        if ("true".equalsIgnoreCase(singleRun = (String)ctx.getData("SingleRun"))) {
            this.nextScheduleTimeAdd = -1L;
        }
        if ((nextRun = (String)ctx.getData("NextRun")) != null) {
            this.nextScheduleTimeAdd = DateTimeUtils.parseDateAsDuration((String)nextRun);
        }
        EntityManagerFactory emf = EntityManagerFactoryManager.get().getOrCreate(emfName);
        try (EntityManager em = emf.createEntityManager();){
            List<ExecutionErrorInfo> errorsToAck = this.findErrorsToAck(em);
            logger.debug("Found {} jobs that can be auto ack", (Object)errorsToAck.size());
            errorsToAck.forEach(error -> {
                AbstractRuntimeManager manager = (AbstractRuntimeManager)RuntimeManagerRegistry.get().getManager(error.getDeploymentId());
                if (manager != null) {
                    ExecutionErrorManager errorManager = manager.getExecutionErrorManager();
                    errorManager.getStorage().acknowledge("SYSTEM", new String[]{error.getErrorId()});
                    logger.debug("Error {} has been auto acknowledged by system based on {}", (Object)error.getErrorId(), (Object)this.getAckRule());
                } else {
                    logger.warn("Unable to ack error {} due missing runtime manager for '{}'", (Object)error.getErrorId(), (Object)error.getDeploymentId());
                }
            });
        }
        return executionResults;
    }

    protected abstract List<ExecutionErrorInfo> findErrorsToAck(EntityManager var1);

    protected abstract String getAckRule();
}

