/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.jpa;

import java.util.Date;
import java.util.List;
import org.jbpm.executor.RequeueAware;
import org.jbpm.executor.entities.RequestInfo;
import org.jbpm.executor.impl.ExecutorImpl;
import org.jbpm.shared.services.impl.JpaPersistenceContext;
import org.jbpm.shared.services.impl.commands.QueryStringCommand;
import org.jbpm.shared.services.impl.commands.RemoveObjectCommand;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.executor.Executor;
import org.kie.api.executor.ExecutorAdminService;
import org.kie.api.executor.STATUS;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorRequestAdminServiceImpl
implements ExecutorAdminService,
RequeueAware {
    private Executor executor;
    private CommandExecutor commandService;

    public void setCommandService(CommandExecutor commandService) {
        this.commandService = commandService;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public int clearAllRequests() {
        List requests = (List)this.commandService.execute((Command)new QueryStringCommand("select r from RequestInfo r"));
        this.commandService.execute((Command)new RemoveObjectCommand(requests.toArray()));
        return requests.size();
    }

    public int clearAllErrors() {
        List errors = (List)this.commandService.execute((Command)new QueryStringCommand("select e from ErrorInfo e"));
        this.commandService.execute((Command)new RemoveObjectCommand(errors.toArray()));
        return errors.size();
    }

    @Override
    public void requeue(Long olderThan) {
        this.commandService.execute((Command)new RequeueRunningJobsCommand(olderThan));
    }

    @Override
    public void requeueById(Long requestId) {
        this.commandService.execute((Command)new RequeueRunningJobCommand(requestId));
    }

    private class RequeueRunningJobCommand
    implements ExecutableCommand<Void> {
        private Logger logger = LoggerFactory.getLogger(RequeueRunningJobCommand.class);
        private static final long serialVersionUID = 8670412133363766161L;
        private Long requestId;

        public RequeueRunningJobCommand(Long id) {
            this.requestId = id;
        }

        public Void execute(Context context) {
            try {
                JpaPersistenceContext ctx = (JpaPersistenceContext)context;
                RequestInfo request = (RequestInfo)ctx.find(RequestInfo.class, (Object)this.requestId);
                if (request == null || request.getStatus() == STATUS.CANCELLED || request.getStatus() == STATUS.DONE) {
                    throw new IllegalArgumentException("Retrying completed or cancelled job is not allowed (job id " + this.requestId + ")");
                }
                this.logger.debug("Requeing request with id : {}, key : {}, start time : {}", new Object[]{request.getId(), request.getKey(), request.getTime()});
                request.setStatus(STATUS.QUEUED);
                ctx.merge((Object)request);
                ((ExecutorImpl)ExecutorRequestAdminServiceImpl.this.executor).scheduleExecutionViaSync(request, request.getTime());
            }
            catch (Exception e) {
                this.logger.warn("Error while trying to requeue jobs that runs for too long {}", (Object)e.getMessage());
            }
            return null;
        }
    }

    private class RequeueRunningJobsCommand
    implements ExecutableCommand<Void> {
        private Logger logger = LoggerFactory.getLogger(RequeueRunningJobsCommand.class);
        private static final long serialVersionUID = 8670412133363766161L;
        private Long upperLimitTime;

        public RequeueRunningJobsCommand(Long maxRunningTime) {
            this.upperLimitTime = System.currentTimeMillis() - maxRunningTime;
        }

        public Void execute(Context context) {
            List requests = null;
            try {
                JpaPersistenceContext ctx = (JpaPersistenceContext)context;
                requests = (List)ctx.queryInTransaction("RunningRequests", List.class);
                for (RequestInfo request : requests) {
                    if (request == null || !this.maxRunningTimeExceeded(request.getTime())) continue;
                    this.logger.debug("Requeing request as the time exceeded for its running state id : {}, key : {}, start time : {}, max time {}", new Object[]{request.getId(), request.getKey(), request.getTime(), new Date(this.upperLimitTime)});
                    request.setStatus(STATUS.QUEUED);
                    ctx.merge((Object)request);
                    ((ExecutorImpl)ExecutorRequestAdminServiceImpl.this.executor).scheduleExecutionViaSync(request, request.getTime());
                }
            }
            catch (Exception e) {
                this.logger.warn("Error while trying to requeue jobs that runs for too long {}", (Object)e.getMessage());
            }
            return null;
        }

        private boolean maxRunningTimeExceeded(Date actualDate) {
            return actualDate.getTime() < this.upperLimitTime;
        }
    }
}

