/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.core.util;

import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequiredParameterValidator {
    private static final Logger logger = LoggerFactory.getLogger(RequiredParameterValidator.class);

    public static void validate(Class<? extends WorkItemHandler> handlerClass, WorkItem workItem) throws Exception {
        Wid handlerWidAnnotation = handlerClass.getDeclaredAnnotation(Wid.class);
        if (workItem == null || handlerWidAnnotation == null || handlerWidAnnotation.parameters() == null || handlerWidAnnotation.parameters().length < 1) {
            return;
        }
        for (WidParameter handlerWidParameter : handlerWidAnnotation.parameters()) {
            if (handlerWidParameter.name() == null || !handlerWidParameter.required() || workItem.getParameter(handlerWidParameter.name()) != null) continue;
            logger.error("Workitem declares following required parameter which does not exist: " + handlerWidParameter.name());
            throw new IllegalArgumentException("Workitem declares following required parameter which does not exist: " + handlerWidParameter.name());
        }
    }
}

