/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dashbuilder.json.JsonArray;
import org.dashbuilder.json.JsonContext;
import org.dashbuilder.json.JsonFactory;
import org.dashbuilder.json.JsonNull;
import org.dashbuilder.json.JsonObjectContext;
import org.dashbuilder.json.JsonType;
import org.dashbuilder.json.JsonUtil;
import org.dashbuilder.json.JsonValue;
import org.dashbuilder.json.JsonVisitor;

public class JsonObject
implements JsonValue {
    private JsonFactory factory;
    private Map<String, JsonValue> map = new LinkedHashMap<String, JsonValue>();

    private static List<String> stringifyOrder(String[] keys) {
        ArrayList<String> toReturn = new ArrayList<String>();
        ArrayList<String> nonNumeric = new ArrayList<String>();
        for (String key : keys) {
            if (key.matches("\\d+")) {
                toReturn.add(key);
                continue;
            }
            nonNumeric.add(key);
        }
        Collections.sort(toReturn);
        toReturn.addAll(nonNumeric);
        return toReturn;
    }

    public JsonObject(JsonFactory factory) {
        this.factory = factory;
    }

    @Override
    public boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    @Override
    public boolean asBoolean() {
        return true;
    }

    @Override
    public double asNumber() {
        return Double.NaN;
    }

    @Override
    public String asString() {
        return "[object Object]";
    }

    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    public JsonValue get(String key) {
        return this.map.get(key);
    }

    public JsonValue getFirst(Collection<String> keys) {
        for (String key : keys) {
            JsonValue val = this.get(key);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    public JsonArray getArray(Collection<String> keys) {
        JsonValue val = this.getFirst(keys);
        if (val == null || val instanceof JsonNull) {
            return null;
        }
        return (JsonArray)val;
    }

    public JsonArray getArray(String key) {
        JsonValue val = this.get(key);
        if (val == null || val instanceof JsonNull) {
            return null;
        }
        return (JsonArray)val;
    }

    public boolean getBoolean(String key) {
        JsonValue val = this.get(key);
        return val != null && val.asBoolean();
    }

    public Number getNumber(String key) {
        return this.getNumber(key, 0);
    }

    public Number getNumber(String key, Number defaultValue) {
        JsonValue val = this.get(key);
        return val == null ? (Number)defaultValue : (Number)val.asNumber();
    }

    public JsonObject getObject(String key) {
        return (JsonObject)this.get(key);
    }

    public String getString(String key) {
        JsonValue val = this.get(key);
        return val == null || val.isEmpty() ? null : val.asString();
    }

    public String getString(Collection<String> keys) {
        JsonValue val = this.getFirst(keys);
        return val == null || val.isEmpty() ? null : val.asString();
    }

    public JsonObject getObject(Collection<String> keys) {
        return (JsonObject)this.getFirst(keys);
    }

    @Override
    public JsonType getType() {
        return JsonType.OBJECT;
    }

    public boolean hasKey(String key) {
        return this.map.containsKey(key);
    }

    public int size() {
        return this.map.size();
    }

    public String[] keys() {
        return this.map.keySet().toArray(new String[this.map.size()]);
    }

    public void put(String key, JsonValue value) {
        if (value == null) {
            value = this.factory.createNull();
        }
        this.map.put(key, value);
    }

    public void put(String key, String value) {
        this.put(key, value == null ? this.factory.createNull() : this.factory.create(value));
    }

    public void put(String key, double value) {
        this.put(key, this.factory.create(value));
    }

    public void put(String key, boolean bool) {
        this.put(key, this.factory.create(bool));
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public void set(String key, JsonValue value) {
        this.put(key, value);
    }

    @Override
    public String toJson() {
        return JsonUtil.stringify((JsonValue)this, 2);
    }

    public String toString() {
        return this.toJson();
    }

    @Override
    public void traverse(JsonVisitor visitor, JsonContext ctx) {
        if (visitor.visit(this, ctx)) {
            JsonObjectContext objCtx = new JsonObjectContext(this);
            for (String key : JsonObject.stringifyOrder(this.keys())) {
                JsonValue value = this.get(key);
                if (value.isEmpty()) continue;
                objCtx.setCurrentKey(key);
                if (!visitor.visitKey(objCtx.getCurrentKey(), objCtx)) continue;
                visitor.accept(this.get(key), objCtx);
                objCtx.setFirst(false);
            }
        }
        visitor.endVisit(this, ctx);
    }
}

