/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.command;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.command.AuditCommand;
import org.kie.api.runtime.Context;
import org.kie.internal.command.ProcessInstanceIdCommand;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class FindVariableInstancesCommand
extends AuditCommand<List<VariableInstanceLog>>
implements ProcessInstanceIdCommand {
    private static final long serialVersionUID = 7087452375594067164L;
    @XmlAttribute(required=true, name="process-instance-id")
    @XmlSchemaType(name="long")
    private Long processInstanceId;
    @XmlAttribute(required=true)
    @XmlSchemaType(name="string")
    private String variableId;

    public FindVariableInstancesCommand() {
    }

    public FindVariableInstancesCommand(long processInstanceId) {
        this.processInstanceId = processInstanceId;
        this.variableId = null;
    }

    public FindVariableInstancesCommand(long processInstanceId, String variableId) {
        this.processInstanceId = processInstanceId;
        this.variableId = variableId;
        if (variableId == null || variableId.isEmpty()) {
            throw new IllegalArgumentException("The variableId field must not be null or empty.");
        }
    }

    public List<VariableInstanceLog> execute(Context cntxt) {
        this.setLogEnvironment(cntxt);
        if (this.variableId == null || this.variableId.isEmpty()) {
            return this.auditLogService.findVariableInstances(this.processInstanceId);
        }
        return this.auditLogService.findVariableInstances(this.processInstanceId, this.variableId);
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getVariableId() {
        return this.variableId;
    }

    public void setVariableId(String variableId) {
        this.variableId = variableId;
    }

    public String toString() {
        if (this.variableId == null || this.variableId.isEmpty()) {
            return AuditLogService.class.getSimpleName() + ".findVariableInstances(" + this.processInstanceId + ")";
        }
        return AuditLogService.class.getSimpleName() + ".findVariableInstances(" + this.processInstanceId + ", " + this.variableId + ")";
    }
}

