/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.model.xml;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.jbpm.services.task.impl.model.xml.AbstractJaxbTaskObject;
import org.jbpm.services.task.impl.model.xml.InternalJaxbWrapper;
import org.kie.api.task.model.Comment;
import org.kie.api.task.model.User;

@XmlRootElement(name="comment")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class JaxbComment
implements Comment {
    @XmlElement
    @XmlSchemaType(name="long")
    private Long id;
    @XmlElement
    @XmlSchemaType(name="string")
    private String text;
    @XmlElement(name="added-by")
    @XmlSchemaType(name="string")
    private String addedBy;
    @XmlElement(name="added-at")
    @XmlSchemaType(name="dateTime")
    private Date addedAt;

    public JaxbComment() {
    }

    public JaxbComment(Comment comment) {
        this.initialize(comment);
    }

    public JaxbComment(String userId, Date commentDate, String commentText) {
        this.addedBy = userId;
        this.addedAt = commentDate;
        this.text = commentText;
    }

    protected void initialize(Comment comment) {
        if (comment != null) {
            this.id = comment.getId();
            this.text = comment.getText();
            User addedByUser = comment.getAddedBy();
            if (addedByUser != null) {
                this.addedBy = addedByUser.getId();
            }
            this.addedAt = comment.getAddedAt();
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public User getAddedBy() {
        return new InternalJaxbWrapper.GetterUser(this.addedBy);
    }

    public String getAddedById() {
        return this.addedBy;
    }

    public Date getAddedAt() {
        return this.addedAt;
    }

    public void setAddedAt(Date commentDate) {
        this.addedAt = commentDate;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        AbstractJaxbTaskObject.unsupported(Comment.class);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        AbstractJaxbTaskObject.unsupported(Comment.class);
    }
}

