/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.factorybeans.helper;

import javax.persistence.EntityManagerFactory;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.spring.factorybeans.KSessionFactoryBean;
import org.kie.spring.factorybeans.helper.KSessionFactoryBeanHelper;
import org.springframework.transaction.PlatformTransactionManager;

public class StatefulKSessionFactoryBeanHelper
extends KSessionFactoryBeanHelper {
    protected KieSession kieSession;

    public StatefulKSessionFactoryBeanHelper(KSessionFactoryBean factoryBean, KieSession kieSession) {
        super(factoryBean);
        this.kieSession = kieSession;
    }

    @Override
    public void internalAfterPropertiesSet() throws Exception {
        JpaConfiguration jpaConfiguration = this.factoryBean.getJpaConfiguration();
        if (jpaConfiguration != null) {
            Environment env = EnvironmentFactory.newEnvironment();
            env.set("org.kie.api.persistence.jpa.EntityManagerFactory", (Object)jpaConfiguration.getEntityManagerFactory());
            env.set("org.kie.transaction.TransactionManager", (Object)jpaConfiguration.getPlatformTransactionManager());
            env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
            this.kieSession = jpaConfiguration.getId() >= 0 ? JPAKnowledgeService.loadStatefulKnowledgeSession((int)jpaConfiguration.getId(), (KieBase)this.kieSession.getKieBase(), (KieSessionConfiguration)this.factoryBean.getConf(), (Environment)env) : JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)this.kieSession.getKieBase(), (KieSessionConfiguration)this.factoryBean.getConf(), (Environment)env);
        }
    }

    @Override
    public void executeBatch() {
        if (this.factoryBean.getBatch() != null && !this.factoryBean.getBatch().isEmpty()) {
            for (Command<?> cmd : this.factoryBean.getBatch()) {
                this.kieSession.execute(cmd);
            }
        }
    }

    @Override
    public Object internalGetObject() {
        return this.kieSession;
    }

    @Override
    public Object internalNewObject() {
        if (this.kieBase != null) {
            return this.kieBase.newKieSession(this.factoryBean.getConf(), null);
        }
        return null;
    }

    public static class JpaConfiguration {
        private EntityManagerFactory emf;
        private PlatformTransactionManager tm;
        private int id = -1;

        public EntityManagerFactory getEntityManagerFactory() {
            return this.emf;
        }

        public void setEntityManagerFactory(EntityManagerFactory emf) {
            this.emf = emf;
        }

        public PlatformTransactionManager getPlatformTransactionManager() {
            return this.tm;
        }

        public void setPlatformTransactionManager(PlatformTransactionManager tm) {
            this.tm = tm;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

