/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.command;

import org.jbpm.casemgmt.api.AdHocFragmentNotFoundException;
import org.jbpm.casemgmt.api.StageNotFoundException;
import org.jbpm.casemgmt.api.model.CaseDefinition;
import org.jbpm.casemgmt.api.model.CaseStage;
import org.jbpm.casemgmt.impl.command.CaseCommand;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.identity.IdentityProvider;

public class TriggerAdHocNodeInStageCommand
extends CaseCommand<Void> {
    private static final long serialVersionUID = 6345222909719335954L;
    private String fragmentName;
    private String stage;
    private long processInstanceId;
    private Object data;
    private CaseDefinition caseDef;

    public TriggerAdHocNodeInStageCommand(IdentityProvider identityProvider, CaseDefinition caseDef, Long processInstanceId, String stage, String fragmentName, Object data) {
        super(identityProvider);
        this.caseDef = caseDef;
        this.fragmentName = fragmentName;
        this.processInstanceId = processInstanceId;
        this.stage = stage;
        this.data = data;
        if (processInstanceId == null || stage == null) {
            throw new IllegalArgumentException("Process instance id and stage id are mandatory");
        }
    }

    public Void execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        ProcessInstance processInstance = ksession.getProcessInstance(this.processInstanceId);
        DynamicNodeInstance dynamicContext = (DynamicNodeInstance)((WorkflowProcessInstanceImpl)processInstance).getNodeInstances(true).stream().filter(ni -> ni instanceof DynamicNodeInstance && (this.stage.equals(ni.getNode().getMetaData().get("UniqueId")) || this.stage.equals(ni.getNodeName()))).findFirst().orElseThrow(() -> new StageNotFoundException("No stage found with id " + this.stage));
        CaseStage caseStage = this.caseDef.getCaseStages().stream().filter(stage -> stage.getId().equals(dynamicContext.getNode().getMetaData().get("UniqueId"))).findFirst().get();
        if (!caseStage.getAdHocFragments().stream().anyMatch(fragment -> fragment.getName().equals(this.fragmentName))) {
            throw new AdHocFragmentNotFoundException("AdHoc fragment '" + this.fragmentName + "' not found in case " + ((WorkflowProcessInstanceImpl)processInstance).getCorrelationKey() + " and stage " + this.stage);
        }
        dynamicContext.signalEvent(this.fragmentName, this.data);
        return null;
    }
}

