/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.event;

import java.util.EventListener;
import java.util.List;
import java.util.Map;
import org.drools.core.event.AbstractEventSupport;
import org.jbpm.casemgmt.api.event.CaseCancelEvent;
import org.jbpm.casemgmt.api.event.CaseCloseEvent;
import org.jbpm.casemgmt.api.event.CaseCommentEvent;
import org.jbpm.casemgmt.api.event.CaseDataEvent;
import org.jbpm.casemgmt.api.event.CaseDestroyEvent;
import org.jbpm.casemgmt.api.event.CaseDynamicSubprocessEvent;
import org.jbpm.casemgmt.api.event.CaseDynamicTaskEvent;
import org.jbpm.casemgmt.api.event.CaseEventListener;
import org.jbpm.casemgmt.api.event.CaseReopenEvent;
import org.jbpm.casemgmt.api.event.CaseRoleAssignmentEvent;
import org.jbpm.casemgmt.api.event.CaseStartEvent;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CommentInstance;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.internal.identity.IdentityProvider;

public class CaseEventSupport
extends AbstractEventSupport<CaseEventListener> {
    private IdentityProvider identityProvider;

    public CaseEventSupport(IdentityProvider identityProvider, List<CaseEventListener> caseEventListeners) {
        this.identityProvider = identityProvider;
        if (caseEventListeners != null) {
            caseEventListeners.forEach(cvl -> this.addEventListener((EventListener)cvl));
        }
    }

    public void fireBeforeCaseStarted(String caseId, String deploymentId, String caseDefinitionId, CaseFileInstance caseFile) {
        if (this.hasListeners()) {
            CaseStartEvent event = new CaseStartEvent(this.identityProvider.getName(), caseId, deploymentId, caseDefinitionId, caseFile);
            this.notifyAllListeners(event, (l, e) -> l.beforeCaseStarted(e));
        }
    }

    public void fireAfterCaseStarted(String caseId, String deploymentId, String caseDefinitionId, CaseFileInstance caseFile, long processInstanceId) {
        if (this.hasListeners()) {
            CaseStartEvent event = new CaseStartEvent(this.identityProvider.getName(), caseId, deploymentId, caseDefinitionId, caseFile, Long.valueOf(processInstanceId));
            this.notifyAllListeners(event, (l, e) -> l.afterCaseStarted(e));
        }
    }

    public void fireBeforeCaseClosed(String caseId, CaseFileInstance caseFile, String comment) {
        if (this.hasListeners()) {
            CaseCloseEvent event = new CaseCloseEvent(this.identityProvider.getName(), caseId, caseFile, comment);
            this.notifyAllListeners(event, (l, e) -> l.beforeCaseClosed(e));
        }
    }

    public void fireAfterCaseClosed(String caseId, CaseFileInstance caseFile, String comment) {
        if (this.hasListeners()) {
            CaseCloseEvent event = new CaseCloseEvent(this.identityProvider.getName(), caseId, caseFile, comment);
            this.notifyAllListeners(event, (l, e) -> l.afterCaseClosed(e));
        }
    }

    public void fireBeforeCaseCancelled(String caseId, CaseFileInstance caseFile, List<Long> processInstanceIds) {
        if (this.hasListeners()) {
            CaseCancelEvent event = new CaseCancelEvent(this.identityProvider.getName(), caseId, caseFile, processInstanceIds);
            this.notifyAllListeners(event, (l, e) -> l.beforeCaseCancelled(e));
        }
    }

    public void fireAfterCaseCancelled(String caseId, CaseFileInstance caseFile, List<Long> processInstanceIds) {
        if (this.hasListeners()) {
            CaseCancelEvent event = new CaseCancelEvent(this.identityProvider.getName(), caseId, caseFile, processInstanceIds);
            this.notifyAllListeners(event, (l, e) -> l.afterCaseCancelled(e));
        }
    }

    public void fireBeforeCaseDestroyed(String caseId, CaseFileInstance caseFile, List<Long> processInstanceIds) {
        if (this.hasListeners()) {
            CaseDestroyEvent event = new CaseDestroyEvent(this.identityProvider.getName(), caseId, caseFile, processInstanceIds);
            this.notifyAllListeners(event, (l, e) -> l.beforeCaseDestroyed(e));
        }
    }

    public void fireAfterCaseDestroyed(String caseId, CaseFileInstance caseFile, List<Long> processInstanceIds) {
        if (this.hasListeners()) {
            CaseDestroyEvent event = new CaseDestroyEvent(this.identityProvider.getName(), caseId, caseFile, processInstanceIds);
            this.notifyAllListeners(event, (l, e) -> l.afterCaseDestroyed(e));
        }
    }

    public void fireBeforeCaseReopened(String caseId, CaseFileInstance caseFile, String deploymentId, String caseDefinitionId, Map<String, Object> data) {
        if (this.hasListeners()) {
            CaseReopenEvent event = new CaseReopenEvent(this.identityProvider.getName(), caseId, caseFile, deploymentId, caseDefinitionId, data);
            this.notifyAllListeners(event, (l, e) -> l.beforeCaseReopen(e));
        }
    }

    public void fireAfterCaseReopened(String caseId, CaseFileInstance caseFile, String deploymentId, String caseDefinitionId, Map<String, Object> data, long processInstanceId) {
        if (this.hasListeners()) {
            CaseReopenEvent event = new CaseReopenEvent(this.identityProvider.getName(), caseId, caseFile, deploymentId, caseDefinitionId, data, Long.valueOf(processInstanceId));
            this.notifyAllListeners(event, (l, e) -> l.afterCaseReopen(e));
        }
    }

    public void fireBeforeCaseCommentAdded(String caseId, CaseFileInstance caseFile, CommentInstance commentInstance) {
        if (this.hasListeners()) {
            CaseCommentEvent event = new CaseCommentEvent(this.identityProvider.getName(), caseId, caseFile, commentInstance);
            this.notifyAllListeners(event, (l, e) -> l.beforeCaseCommentAdded(e));
        }
    }

    public void fireAfterCaseCommentAdded(String caseId, CaseFileInstance caseFile, CommentInstance commentInstance) {
        if (this.hasListeners()) {
            CaseCommentEvent event = new CaseCommentEvent(this.identityProvider.getName(), caseId, caseFile, commentInstance);
            this.notifyAllListeners(event, (l, e) -> l.afterCaseCommentAdded(e));
        }
    }

    public void fireBeforeCaseCommentUpdated(String caseId, CaseFileInstance caseFile, CommentInstance commentInstance) {
        if (this.hasListeners()) {
            CaseCommentEvent event = new CaseCommentEvent(this.identityProvider.getName(), caseId, caseFile, commentInstance);
            this.notifyAllListeners(event, (l, e) -> l.beforeCaseCommentUpdated(e));
        }
    }

    public void fireAfterCaseCommentUpdated(String caseId, CaseFileInstance caseFile, CommentInstance commentInstance) {
        if (this.hasListeners()) {
            CaseCommentEvent event = new CaseCommentEvent(this.identityProvider.getName(), caseId, caseFile, commentInstance);
            this.notifyAllListeners(event, (l, e) -> l.afterCaseCommentUpdated(e));
        }
    }

    public void fireBeforeCaseCommentRemoved(String caseId, CaseFileInstance caseFile, CommentInstance commentInstance) {
        if (this.hasListeners()) {
            CaseCommentEvent event = new CaseCommentEvent(this.identityProvider.getName(), caseId, caseFile, commentInstance);
            this.notifyAllListeners(event, (l, e) -> l.beforeCaseCommentRemoved(e));
        }
    }

    public void fireAfterCaseCommentRemoved(String caseId, CaseFileInstance caseFile, CommentInstance commentInstance) {
        if (this.hasListeners()) {
            CaseCommentEvent event = new CaseCommentEvent(this.identityProvider.getName(), caseId, caseFile, commentInstance);
            this.notifyAllListeners(event, (l, e) -> l.afterCaseCommentRemoved(e));
        }
    }

    public void fireBeforeCaseRoleAssignmentAdded(String caseId, CaseFileInstance caseFile, String role, OrganizationalEntity entity) {
        if (this.hasListeners()) {
            CaseRoleAssignmentEvent event = new CaseRoleAssignmentEvent(this.identityProvider.getName(), caseId, caseFile, role, entity);
            this.notifyAllListeners(event, (l, e) -> l.beforeCaseRoleAssignmentAdded(e));
        }
    }

    public void fireAfterCaseRoleAssignmentAdded(String caseId, CaseFileInstance caseFile, String role, OrganizationalEntity entity) {
        if (this.hasListeners()) {
            CaseRoleAssignmentEvent event = new CaseRoleAssignmentEvent(this.identityProvider.getName(), caseId, caseFile, role, entity);
            this.notifyAllListeners(event, (l, e) -> l.afterCaseRoleAssignmentAdded(e));
        }
    }

    public void fireBeforeCaseRoleAssignmentRemoved(String caseId, CaseFileInstance caseFile, String role, OrganizationalEntity entity) {
        if (this.hasListeners()) {
            CaseRoleAssignmentEvent event = new CaseRoleAssignmentEvent(this.identityProvider.getName(), caseId, caseFile, role, entity);
            this.notifyAllListeners(event, (l, e) -> l.beforeCaseRoleAssignmentRemoved(e));
        }
    }

    public void fireAfterCaseRoleAssignmentRemoved(String caseId, CaseFileInstance caseFile, String role, OrganizationalEntity entity) {
        if (this.hasListeners()) {
            CaseRoleAssignmentEvent event = new CaseRoleAssignmentEvent(this.identityProvider.getName(), caseId, caseFile, role, entity);
            this.notifyAllListeners(event, (l, e) -> l.afterCaseRoleAssignmentRemoved(e));
        }
    }

    public void fireBeforeCaseDataAdded(String caseId, CaseFileInstance caseFile, String definitionId, Map<String, Object> data) {
        if (this.hasListeners()) {
            CaseDataEvent event = new CaseDataEvent(this.identityProvider.getName(), caseId, caseFile, definitionId, data);
            this.notifyAllListeners(event, (l, e) -> l.beforeCaseDataAdded(e));
        }
    }

    public void fireAfterCaseDataAdded(String caseId, CaseFileInstance caseFile, String definitionId, Map<String, Object> data) {
        if (this.hasListeners()) {
            CaseDataEvent event = new CaseDataEvent(this.identityProvider.getName(), caseId, caseFile, definitionId, data);
            this.notifyAllListeners(event, (l, e) -> l.afterCaseDataAdded(e));
        }
    }

    public void fireBeforeCaseDataRemoved(String caseId, CaseFileInstance caseFile, String definitionId, Map<String, Object> data) {
        if (this.hasListeners()) {
            CaseDataEvent event = new CaseDataEvent(this.identityProvider.getName(), caseId, caseFile, definitionId, data);
            this.notifyAllListeners(event, (l, e) -> l.beforeCaseDataRemoved(e));
        }
    }

    public void fireAfterCaseDataRemoved(String caseId, CaseFileInstance caseFile, String definitionId, Map<String, Object> data) {
        if (this.hasListeners()) {
            CaseDataEvent event = new CaseDataEvent(this.identityProvider.getName(), caseId, caseFile, definitionId, data);
            this.notifyAllListeners(event, (l, e) -> l.afterCaseDataRemoved(e));
        }
    }

    public void fireBeforeDynamicTaskAdded(String caseId, CaseFileInstance caseFile, long processInstanceId, String nodeType, Map<String, Object> parameters) {
        if (this.hasListeners()) {
            CaseDynamicTaskEvent event = new CaseDynamicTaskEvent(this.identityProvider.getName(), caseId, caseFile, nodeType, parameters, processInstanceId);
            this.notifyAllListeners(event, (l, e) -> l.beforeDynamicTaskAdded(e));
        }
    }

    public void fireAfterDynamicTaskAdded(String caseId, CaseFileInstance caseFile, long processInstanceId, String nodeType, Map<String, Object> parameters) {
        if (this.hasListeners()) {
            CaseDynamicTaskEvent event = new CaseDynamicTaskEvent(this.identityProvider.getName(), caseId, caseFile, nodeType, parameters, processInstanceId);
            this.notifyAllListeners(event, (l, e) -> l.afterDynamicTaskAdded(e));
        }
    }

    public void fireBeforeDynamicProcessAdded(String caseId, CaseFileInstance caseFile, long processInstanceId, String processId, Map<String, Object> parameters) {
        if (this.hasListeners()) {
            CaseDynamicSubprocessEvent event = new CaseDynamicSubprocessEvent(this.identityProvider.getName(), caseId, caseFile, processId, parameters, processInstanceId);
            this.notifyAllListeners(event, (l, e) -> l.beforeDynamicProcessAdded(e));
        }
    }

    public void fireAfterDynamicProcessAdded(String caseId, CaseFileInstance caseFile, long processInstanceId, String processId, Map<String, Object> parameters, long subProcessInstanceId) {
        if (this.hasListeners()) {
            CaseDynamicSubprocessEvent event = new CaseDynamicSubprocessEvent(this.identityProvider.getName(), caseId, caseFile, processId, parameters, processInstanceId, subProcessInstanceId);
            this.notifyAllListeners(event, (l, e) -> l.afterDynamicProcessAdded(e));
        }
    }

    public void reset() {
        this.clear();
    }
}

