/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jdbc.drivers.modifiers;

import com.arjuna.ats.internal.jdbc.drivers.modifiers.ConnectionModifier;
import com.arjuna.ats.internal.jdbc.drivers.modifiers.IsSameRMModifier;
import com.arjuna.ats.internal.jdbc.drivers.modifiers.list;
import com.arjuna.ats.jdbc.common.jdbcPropertyManager;
import com.arjuna.ats.jdbc.logging.jdbcLogger;
import com.arjuna.common.internal.util.ClassloadingUtility;
import java.util.Enumeration;
import java.util.Hashtable;

public class ModifierFactory {
    private static ConnectionModifier isSameRMModifier = new IsSameRMModifier();
    private static boolean defaultIsSameRMOverride = jdbcPropertyManager.getJDBCEnvironmentBean().getDefaultIsSameRMOverride();
    private static Hashtable<String, ConnectionModifier> _modifiers = new Hashtable();

    public static synchronized void putModifier(String dbName, int major, int minor, String modclass) {
        ConnectionModifier connectionModifier = ClassloadingUtility.loadAndInstantiateClass(ConnectionModifier.class, modclass, null);
        if (connectionModifier != null) {
            _modifiers.put(dbName + "_" + major + "_" + minor, connectionModifier);
        }
    }

    public static synchronized ConnectionModifier getModifier(String dbName, int major, int minor) {
        ConnectionModifier modifier;
        String exactMatch = null;
        String majorMatch = null;
        String driverMatch = null;
        Enumeration<String> e = _modifiers.keys();
        dbName = dbName.toLowerCase();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            if (s.equalsIgnoreCase(dbName + "_" + major + "_" + minor)) {
                exactMatch = s;
            }
            if (s.equalsIgnoreCase(dbName + "_" + major + "_-1")) {
                majorMatch = s;
            }
            if (!s.equalsIgnoreCase(dbName + "_-1_-1")) continue;
            driverMatch = s;
        }
        ConnectionModifier connectionModifier = modifier = defaultIsSameRMOverride ? isSameRMModifier : null;
        if (driverMatch != null) {
            modifier = _modifiers.get(driverMatch);
        }
        if (majorMatch != null) {
            modifier = _modifiers.get(majorMatch);
        }
        if (exactMatch != null) {
            modifier = _modifiers.get(exactMatch);
        }
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.tracef("ConnectionModifier for: %s for %s %d/%d (defaultIsSameRMOverride was %b)", new Object[]{modifier == null ? null : modifier.getClass().getName(), dbName, major, minor, defaultIsSameRMOverride});
        }
        return modifier;
    }

    static {
        new list();
    }
}

