/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jbpm.kie.services.impl.FormManagerService;

public class FormManagerServiceImpl
implements FormManagerService {
    private Map<String, Map<String, String>> formsRegistry = new HashMap<String, Map<String, String>>();

    @Override
    public void registerForm(String deploymentId, String key, String formContent) {
        if (this.formsRegistry.get(deploymentId) == null) {
            this.formsRegistry.put(deploymentId, new HashMap());
        }
        this.formsRegistry.get(deploymentId).put(key, formContent);
    }

    @Override
    public void unRegisterForms(String deploymentId) {
        this.formsRegistry.remove(deploymentId);
    }

    @Override
    public Map<String, String> getAllFormsByDeployment(String deploymentId) {
        return this.formsRegistry.get(deploymentId);
    }

    @Override
    public Set<String> getAllDeployments() {
        return this.formsRegistry.keySet();
    }

    @Override
    public Map<String, String> getAllForms() {
        HashMap<String, String> allForms = new HashMap<String, String>();
        for (Map<String, String> formsByDep : this.formsRegistry.values()) {
            allForms.putAll(formsByDep);
        }
        return allForms;
    }

    @Override
    public String getFormByKey(String deploymentId, String key) {
        if (deploymentId != null && this.formsRegistry != null && this.formsRegistry.containsKey(deploymentId)) {
            return this.formsRegistry.get(deploymentId).get(key);
        }
        return null;
    }
}

