/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.query.preprocessor;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.jbpm.kie.services.impl.query.preprocessor.UserTasksPreprocessor;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.identity.IdentityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PotOwnerTasksPreprocessor
extends UserTasksPreprocessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PotOwnerTasksPreprocessor.class);
    private IdentityProvider identityProvider;
    private UserGroupCallback userGroupCallback;

    public PotOwnerTasksPreprocessor(IdentityProvider identityProvider, UserGroupCallback userGroupCallback, DataSetMetadata metadata) {
        super(metadata);
        this.identityProvider = identityProvider;
        this.userGroupCallback = userGroupCallback;
    }

    @Override
    public void preprocess(DataSetLookup lookup) {
        if (this.identityProvider == null || this.userGroupCallback == null) {
            return;
        }
        List groupsForUser = Optional.ofNullable(this.userGroupCallback.getGroupsForUser(this.identityProvider.getName())).orElse(new ArrayList());
        ArrayList<String> orgEntities = new ArrayList<String>(groupsForUser);
        orgEntities.add(this.identityProvider.getName());
        ColumnFilter myGroupFilter = FilterFactory.AND((ColumnFilter[])new ColumnFilter[]{FilterFactory.equalsTo((String)"ID", orgEntities), FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{FilterFactory.equalsTo((String)"ACTUALOWNER", (Comparable)((Object)"")), FilterFactory.isNull((String)"ACTUALOWNER")})});
        ColumnFilter columnFilter = FilterFactory.AND((ColumnFilter[])new ColumnFilter[]{FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{FilterFactory.isNull((String)"ENTITY_ID"), FilterFactory.notEqualsTo((String)"ENTITY_ID", (Comparable)((Object)this.identityProvider.getName()))}), FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{myGroupFilter, FilterFactory.equalsTo((String)"ACTUALOWNER", (Comparable)((Object)this.identityProvider.getName()))})});
        LOGGER.debug("Adding column filter: {}", (Object)columnFilter);
        if (lookup.getFirstFilterOp() != null) {
            lookup.getFirstFilterOp().addFilterColumn(new ColumnFilter[]{columnFilter});
        } else {
            DataSetFilter filter = new DataSetFilter();
            filter.addFilterColumn(new ColumnFilter[]{columnFilter});
            lookup.addOperation(new DataSetOp[]{filter});
        }
        super.preprocess(lookup);
    }
}

