/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.reteoo.compiled;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import org.drools.compiler.builder.InternalKnowledgeBuilder;
import org.drools.compiler.commons.jci.compilers.CompilationResult;
import org.drools.compiler.commons.jci.compilers.JavaCompiler;
import org.drools.compiler.commons.jci.compilers.JavaCompilerFactory;
import org.drools.compiler.compiler.JavaConfiguration;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.base.ClassObjectType;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.compiled.AssertHandler;
import org.drools.core.reteoo.compiled.CompiledNetwork;
import org.drools.core.reteoo.compiled.DeclarationsHandler;
import org.drools.core.reteoo.compiled.DelegateMethodsHandler;
import org.drools.core.reteoo.compiled.HashedAlphasDeclaration;
import org.drools.core.reteoo.compiled.ModifyHandler;
import org.drools.core.reteoo.compiled.NetworkHandler;
import org.drools.core.reteoo.compiled.ObjectTypeNodeParser;
import org.drools.core.reteoo.compiled.SetNodeReferenceHandler;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.util.IoUtils;
import org.drools.reflective.classloader.ProjectClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectTypeNodeCompiler {
    private static final String NEWLINE = "\n";
    private static final String PACKAGE_NAME = "org.drools.core.reteoo.compiled";
    private static final String BINARY_PACKAGE_NAME = "org.drools.core.reteoo.compiled".replace('.', '/');
    private String className;
    private String generatedClassSimpleName;
    private ObjectTypeNode objectTypeNode;
    private StringBuilder builder = new StringBuilder();
    private static final Logger logger = LoggerFactory.getLogger(ObjectTypeNodeCompiler.class);
    private static final JavaCompiler JAVA_COMPILER = JavaCompilerFactory.INSTANCE.loadCompiler(JavaConfiguration.CompilerType.NATIVE, "1.8");

    private ObjectTypeNodeCompiler(ObjectTypeNode objectTypeNode) {
        this.objectTypeNode = objectTypeNode;
        ClassObjectType classObjectType = (ClassObjectType)objectTypeNode.getObjectType();
        this.className = classObjectType.getClassName().replace("$", ".");
        String classObjectTypeName = classObjectType.getClassName().replace('.', '_');
        String randomId = UUID.randomUUID().toString().replace("-", "");
        this.generatedClassSimpleName = String.format("Compiled%sNetwork%d%s", classObjectTypeName, objectTypeNode.getId(), randomId);
    }

    private SourceGenerated generateSource() {
        this.createClassDeclaration();
        ObjectTypeNodeParser parser = new ObjectTypeNodeParser(this.objectTypeNode);
        DeclarationsHandler declarations = new DeclarationsHandler(this.builder);
        parser.accept((NetworkHandler)declarations);
        Collection hashedAlphaDeclarations = declarations.getHashedAlphaDeclarations();
        this.createConstructor(hashedAlphaDeclarations);
        SetNodeReferenceHandler setNode = new SetNodeReferenceHandler(this.builder);
        parser.accept((NetworkHandler)setNode);
        AssertHandler assertHandler = new AssertHandler(this.builder, this.className, hashedAlphaDeclarations.size() > 0);
        parser.accept((NetworkHandler)assertHandler);
        ModifyHandler modifyHandler = new ModifyHandler(this.builder, this.className, hashedAlphaDeclarations.size() > 0);
        parser.accept((NetworkHandler)modifyHandler);
        DelegateMethodsHandler delegateMethodsHandler = new DelegateMethodsHandler(this.builder);
        parser.accept((NetworkHandler)delegateMethodsHandler);
        this.builder.append("}").append(NEWLINE);
        return new SourceGenerated(this.builder.toString(), parser.getIndexableConstraint());
    }

    private void createClassDeclaration() {
        this.builder.append("package ").append(PACKAGE_NAME).append(";").append(NEWLINE);
        this.builder.append("public class ").append(this.generatedClassSimpleName).append(" extends ").append(CompiledNetwork.class.getName()).append("{ ").append(NEWLINE);
        this.builder.append("org.drools.core.spi.InternalReadAccessor readAccessor;\n");
    }

    private void createConstructor(Collection<HashedAlphasDeclaration> hashedAlphaDeclarations) {
        this.builder.append("public ").append(this.generatedClassSimpleName).append("(org.drools.core.spi.InternalReadAccessor readAccessor) {").append(NEWLINE);
        this.builder.append("this.readAccessor = readAccessor;\n");
        for (HashedAlphasDeclaration declaration : hashedAlphaDeclarations) {
            String mapVariableName = declaration.getVariableName();
            for (Object hashedValue : declaration.getHashedValues()) {
                String nodeId;
                Object value = hashedValue;
                if (value == null) {
                    nodeId = declaration.getNodeId(hashedValue);
                    this.builder.append(mapVariableName).append(".put(null,").append(nodeId).append(");");
                    this.builder.append(NEWLINE);
                    continue;
                }
                if (value.getClass().equals(String.class)) {
                    value = "\"" + value + "\"";
                } else if (value instanceof BigDecimal) {
                    value = "new java.math.BigDecimal(\"" + value + "\")";
                } else if (value instanceof BigInteger) {
                    value = "new java.math.BigInteger(\"" + value + "\")";
                }
                nodeId = declaration.getNodeId(hashedValue);
                this.builder.append(mapVariableName).append(".put(").append(value).append(", ").append(nodeId).append(");");
                this.builder.append(NEWLINE);
            }
        }
        this.builder.append("}").append(NEWLINE);
    }

    private String getName() {
        return this.getPackageName() + "." + this.generatedClassSimpleName;
    }

    private String getBinaryName() {
        return BINARY_PACKAGE_NAME + "/" + this.generatedClassSimpleName + ".class";
    }

    private String getSourceName() {
        return BINARY_PACKAGE_NAME + "/" + this.generatedClassSimpleName + ".java";
    }

    private String getPackageName() {
        return PACKAGE_NAME;
    }

    public static CompiledNetwork compile(InternalKnowledgeBuilder kBuilder, ObjectTypeNode objectTypeNode) {
        CompiledNetwork network;
        if (objectTypeNode == null) {
            throw new IllegalArgumentException("ObjectTypeNode cannot be null!");
        }
        if (kBuilder == null) {
            throw new IllegalArgumentException("PackageBuilder cannot be null!");
        }
        ObjectTypeNodeCompiler compiler = new ObjectTypeNodeCompiler(objectTypeNode);
        String packageName = compiler.getPackageName();
        PackageRegistry pkgReg = kBuilder.getPackageRegistry(packageName);
        if (pkgReg == null) {
            kBuilder.addPackage(new PackageDescr(packageName));
            pkgReg = kBuilder.getPackageRegistry(packageName);
        }
        SourceGenerated source = compiler.generateSource();
        logger.debug("Generated alpha node compiled network source:\n" + source.source);
        MemoryFileSystem mfs = new MemoryFileSystem();
        mfs.write(compiler.getSourceName(), source.source.getBytes(IoUtils.UTF8_CHARSET));
        MemoryFileSystem trg = new MemoryFileSystem();
        ProjectClassLoader rootClassLoader = (ProjectClassLoader)kBuilder.getRootClassLoader();
        CompilationResult compiled = JAVA_COMPILER.compile(new String[]{compiler.getSourceName()}, mfs, trg, (ClassLoader)rootClassLoader);
        if (compiled.getErrors().length > 0) {
            throw new RuntimeException("This is a bug. Please contact the development team:\n" + Arrays.toString(compiled.getErrors()));
        }
        rootClassLoader.defineClass(compiler.getName(), trg.getBytes(compiler.getBinaryName()));
        try {
            Class<?> aClass = Class.forName(compiler.getName(), true, (ClassLoader)rootClassLoader);
            IndexableConstraint indexableConstraint = source.indexableConstraint;
            network = (CompiledNetwork)aClass.getConstructor(InternalReadAccessor.class).newInstance(indexableConstraint != null ? indexableConstraint.getFieldExtractor() : null);
        }
        catch (Exception e) {
            throw new RuntimeException("This is a bug. Please contact the development team", e);
        }
        return network;
    }

    public static class SourceGenerated {
        public final String source;
        public final IndexableConstraint indexableConstraint;

        public SourceGenerated(String source, IndexableConstraint indexableConstraint) {
            this.source = source;
            this.indexableConstraint = indexableConstraint;
        }
    }
}

