/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.impl.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.kie.internal.task.api.TaskVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="TaskVariableImpl", indexes={@Index(name="IDX_TaskVariableImpl_taskId", columnList="taskId"), @Index(name="IDX_TaskVariableImpl_pInstId", columnList="processInstanceId"), @Index(name="IDX_TaskVariableImpl_processId", columnList="processId")})
@SequenceGenerator(name="taskVarIdSeq", sequenceName="TASK_VAR_ID_SEQ", allocationSize=1)
public class TaskVariableImpl
implements TaskVariable,
Serializable {
    private static final long serialVersionUID = 5388016330549830048L;
    private static final Logger logger = LoggerFactory.getLogger(TaskVariableImpl.class);
    @Transient
    private final int VARIABLE_LOG_LENGTH = Integer.parseInt(System.getProperty("org.jbpm.task.var.log.length", "4000"));
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="taskVarIdSeq")
    private Long id;
    private Long taskId;
    private Long processInstanceId;
    private String processId;
    private String name;
    @Column(length=4000)
    private String value;
    @Enumerated(value=EnumType.ORDINAL)
    private TaskVariable.VariableType type;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date modificationDate;

    public Long getId() {
        return this.id;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        if (value != null && value.length() > this.VARIABLE_LOG_LENGTH) {
            value = value.substring(0, this.VARIABLE_LOG_LENGTH);
            logger.warn("Task variable '{}' content was trimmed as it was too long (more than {} characters)", (Object)this.name, (Object)this.VARIABLE_LOG_LENGTH);
        }
        this.value = value;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    public TaskVariable.VariableType getType() {
        return this.type;
    }

    public void setType(TaskVariable.VariableType type) {
        this.type = type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.modificationDate == null ? 0 : this.modificationDate.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.processId == null ? 0 : this.processId.hashCode());
        result = 31 * result + (this.processInstanceId == null ? 0 : this.processInstanceId.hashCode());
        result = 31 * result + (this.taskId == null ? 0 : this.taskId.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskVariableImpl other = (TaskVariableImpl)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.modificationDate == null ? other.modificationDate != null : !this.modificationDate.equals(other.modificationDate)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.processId == null ? other.processId != null : !this.processId.equals(other.processId)) {
            return false;
        }
        if (this.processInstanceId == null ? other.processInstanceId != null : !this.processInstanceId.equals(other.processInstanceId)) {
            return false;
        }
        if (this.taskId == null ? other.taskId != null : !this.taskId.equals(other.taskId)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "TaskVariableImpl [id=" + this.id + ", taskId=" + this.taskId + ", processInstanceId=" + this.processInstanceId + ", processId=" + this.processId + ", name=" + this.name + ", value=" + this.value + ", type=" + this.type + ", modificationDate=" + this.modificationDate + "]";
    }
}

