/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.KiePMMLTarget;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.transformations.KiePMMLDefineFunction;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;

public class ProcessingDTO {
    private final List<KiePMMLDefineFunction> defineFunctions;
    private final List<KiePMMLDerivedField> derivedFields;
    private final List<KiePMMLOutputField> outputFields;
    private final List<KiePMMLTarget> kiePMMLTargets;
    private final List<KiePMMLNameValue> kiePMMLNameValues;
    private final List<String> orderedReasonCodes;
    private final List<MiningField> miningFields;

    public ProcessingDTO(KiePMMLModel model, List<KiePMMLNameValue> kiePMMLNameValues, List<String> orderedReasonCodes) {
        this.derivedFields = new ArrayList<KiePMMLDerivedField>();
        this.defineFunctions = new ArrayList<KiePMMLDefineFunction>();
        if (model.getTransformationDictionary() != null) {
            if (model.getTransformationDictionary().getDerivedFields() != null) {
                this.derivedFields.addAll(model.getTransformationDictionary().getDerivedFields());
            }
            if (model.getTransformationDictionary().getDefineFunctions() != null) {
                this.defineFunctions.addAll(model.getTransformationDictionary().getDefineFunctions());
            }
        }
        if (model.getLocalTransformations() != null && model.getLocalTransformations().getDerivedFields() != null) {
            this.derivedFields.addAll(model.getLocalTransformations().getDerivedFields());
        }
        this.outputFields = model.getKiePMMLOutputFields();
        this.kiePMMLTargets = model.getKiePMMLTargets();
        this.kiePMMLNameValues = kiePMMLNameValues;
        this.orderedReasonCodes = orderedReasonCodes;
        this.miningFields = model.getMiningFields();
    }

    public ProcessingDTO(List<KiePMMLDefineFunction> defineFunctions, List<KiePMMLDerivedField> derivedFields, List<KiePMMLOutputField> outputFields, List<KiePMMLTarget> kiePMMLTargets, List<KiePMMLNameValue> kiePMMLNameValues, List<MiningField> miningFields, List<String> orderedReasonCodes) {
        this.defineFunctions = defineFunctions;
        this.derivedFields = derivedFields;
        this.outputFields = outputFields;
        this.kiePMMLTargets = kiePMMLTargets;
        this.miningFields = miningFields;
        this.kiePMMLNameValues = kiePMMLNameValues;
        this.orderedReasonCodes = orderedReasonCodes;
    }

    public List<KiePMMLDefineFunction> getDefineFunctions() {
        return Collections.unmodifiableList(this.defineFunctions);
    }

    public List<KiePMMLDerivedField> getDerivedFields() {
        return Collections.unmodifiableList(this.derivedFields);
    }

    public List<KiePMMLOutputField> getOutputFields() {
        return Collections.unmodifiableList(this.outputFields);
    }

    public List<KiePMMLTarget> getKiePMMLTargets() {
        return Collections.unmodifiableList(this.kiePMMLTargets);
    }

    public List<KiePMMLNameValue> getKiePMMLNameValues() {
        return Collections.unmodifiableList(this.kiePMMLNameValues);
    }

    public boolean addKiePMMLNameValue(KiePMMLNameValue toAdd) {
        this.kiePMMLNameValues.removeIf(kpm -> kpm.getName().equals(toAdd.getName()));
        return this.kiePMMLNameValues.add(toAdd);
    }

    public List<String> getOrderedReasonCodes() {
        return Collections.unmodifiableList(this.orderedReasonCodes);
    }

    public boolean addOrderedReasonCodes(List<String> toAdd) {
        return this.orderedReasonCodes.addAll(toAdd);
    }

    public List<MiningField> getMiningFields() {
        return Collections.unmodifiableList(this.miningFields);
    }
}

