/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.ParseProblemException;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.io.InputStream;
import org.kie.pmml.api.exceptions.ExternalException;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaParserUtils {
    private static final Logger logger = LoggerFactory.getLogger(JavaParserUtils.class);
    public static final String MAIN_CLASS_NOT_FOUND = "Main class not found";

    private JavaParserUtils() {
    }

    public static CompilationUnit getFromFileName(String fileName) {
        try {
            InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
            return StaticJavaParser.parse((InputStream)resource);
        }
        catch (ParseProblemException e) {
            throw new KiePMMLInternalException(String.format("Failed to parse %s due to %s", fileName, e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            throw new ExternalException(String.format("Failed to read %s due to %s", fileName, e.getMessage()), (Throwable)e);
        }
    }

    public static CompilationUnit getFromSource(String source) {
        try {
            return StaticJavaParser.parse((String)source);
        }
        catch (ParseProblemException e) {
            throw new KiePMMLInternalException(String.format("Failed to parse\r\n%s\r\ndue to %s", source, e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            throw new ExternalException(String.format("Failed to parse\r\n%s\r\ndue to %s", source, e.getMessage()), (Throwable)e);
        }
    }

    public static CompilationUnit getKiePMMLModelCompilationUnit(String className, String packageName, String javaTemplate, String modelClassName) {
        logger.trace("getKiePMMLModelCompilationUnit {} {}", (Object)className, (Object)packageName);
        CompilationUnit templateCU = JavaParserUtils.getFromFileName(javaTemplate);
        CompilationUnit toReturn = templateCU.clone();
        if (packageName != null && !packageName.isEmpty()) {
            toReturn.setPackageDeclaration(packageName);
        }
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)toReturn.getClassByName(modelClassName).orElseThrow(() -> new KiePMMLException("Main class not found: " + modelClassName));
        modelTemplate.setName(className);
        return toReturn;
    }

    public static String getFullClassName(CompilationUnit cu) {
        String packageName = ((PackageDeclaration)cu.getPackageDeclaration().orElseThrow(() -> new KiePMMLException("Missing package declaration for " + cu.toString()))).getName().asString();
        String className = cu.getType(0).getName().asString();
        return packageName + "." + className;
    }

    public static MethodDeclaration parseMethod(String method) {
        return (MethodDeclaration)StaticJavaParser.parse((String)("public class MyClass { " + method + " }")).findFirst(MethodDeclaration.class).orElseThrow(() -> new IllegalArgumentException("Invalid method provided"));
    }

    public static BlockStmt parseBlock(String block) {
        return StaticJavaParser.parseBlock((String)block);
    }

    public static Statement parseStatement(String statement) {
        return StaticJavaParser.parseStatement((String)statement);
    }

    public static Expression parseExpression(String statement) {
        return StaticJavaParser.parseExpression((String)statement);
    }

    public static boolean equalsNode(Node node1, Node node2) {
        return node1.toString().equals(node2.toString());
    }
}

