/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.Headers;
import org.jboss.logging.Logger;
import org.json.JSONObject;
import org.kie.server.router.ConfigurationManager;

public class AdminHttpHandler
implements HttpHandler {
    private static final Logger log = Logger.getLogger(AdminHttpHandler.class);
    private ConfigurationManager configurationManager;

    public AdminHttpHandler(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String path = exchange.getRelativePath();
        if (path.startsWith("/list")) {
            String jsonConfig = this.configurationManager.toJsonConfig();
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
            exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, jsonConfig.getBytes("UTF-8").length);
            exchange.getResponseSender().send(jsonConfig);
            return;
        }
        exchange.getRequestReceiver().receiveFullString((ex, data) -> {
            try {
                JSONObject jsonData = new JSONObject(data);
                String containerId = jsonData.getString("containerId");
                String alias = jsonData.getString("alias");
                String serverId = jsonData.getString("serverId");
                String serverUrl = jsonData.getString("serverUrl");
                String releaseId = jsonData.getString("releaseId");
                if (path.startsWith("/add")) {
                    log.infof("Added %s as server location for container %s ", (Object)serverUrl, (Object)containerId);
                    this.configurationManager.add(containerId, alias, serverId, serverUrl, releaseId);
                    ResponseCodeHandler.HANDLE_200.handleRequest(exchange);
                } else if (path.startsWith("/remove")) {
                    log.infof("Removed %s as server location for container %s ", (Object)serverUrl, (Object)containerId);
                    this.configurationManager.remove(containerId, alias, serverId, serverUrl, releaseId);
                    ResponseCodeHandler.HANDLE_200.handleRequest(exchange);
                } else {
                    exchange.getResponseHeaders().put(Headers.STATUS, "");
                    ResponseCodeHandler.HANDLE_404.handleRequest(exchange);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error while performing admin operation", e);
            }
        });
    }
}

