/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.processinstance;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.jbpm.persistence.api.ProcessPersistenceContext;
import org.jbpm.persistence.api.ProcessPersistenceContextManager;
import org.jbpm.process.core.async.AsyncSignalEventCommand;
import org.jbpm.process.core.async.BatchAsyncSignalEventCommand;
import org.jbpm.process.instance.event.DefaultSignalManager;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.manager.RuntimeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPASignalManager
extends DefaultSignalManager {
    private static final long BATCH_THREASHOLD = Long.getLong("org.kie.jbpm.signal.batch.threadshold", 100L);
    private static final long BATCH_SIZE = Long.getLong("org.kie.jbpm.signal.batch.size", 50L);
    private static final String ASYNC_SIGNAL_PREFIX = "ASYNC-";
    private static final Logger logger = LoggerFactory.getLogger(JPASignalManager.class);

    public JPASignalManager(InternalKnowledgeRuntime kruntime) {
        super(kruntime);
    }

    public void signalEvent(String type, Object event) {
        String actualSignalType = type.replaceFirst(ASYNC_SIGNAL_PREFIX, "");
        ProcessPersistenceContextManager contextManager = (ProcessPersistenceContextManager)this.getKnowledgeRuntime().getEnvironment().get("org.kie.api.persistence.PersistenceContextManager");
        ProcessPersistenceContext context = contextManager.getProcessPersistenceContext();
        List processInstancesToSignalList = context.getProcessInstancesWaitingForEvent(actualSignalType);
        if (type.startsWith(ASYNC_SIGNAL_PREFIX)) {
            RuntimeManager runtimeManager = (RuntimeManager)this.getKnowledgeRuntime().getEnvironment().get("RuntimeManager");
            ExecutorService executorService = (ExecutorService)this.getKnowledgeRuntime().getEnvironment().get("ExecutorService");
            if (runtimeManager != null && executorService != null) {
                for (Long processInstanceId : processInstancesToSignalList) {
                    CommandContext ctx = new CommandContext();
                    ctx.setData("deploymentId", (Object)runtimeManager.getIdentifier());
                    ctx.setData("processInstanceId", (Object)processInstanceId);
                    ctx.setData("Signal", (Object)actualSignalType);
                    ctx.setData("Event", event);
                    executorService.scheduleRequest(AsyncSignalEventCommand.class.getName(), ctx);
                }
                return;
            }
            logger.warn("Signal should be sent asynchronously but there is no executor service available, continuing sync...");
        }
        if ((long)processInstancesToSignalList.size() >= BATCH_THREASHOLD) {
            int currentIndex = 0;
            RuntimeManager runtimeManager = (RuntimeManager)this.getKnowledgeRuntime().getEnvironment().get("RuntimeManager");
            ExecutorService executorService = (ExecutorService)this.getKnowledgeRuntime().getEnvironment().get("ExecutorService");
            currentIndex = 0;
            while (currentIndex < processInstancesToSignalList.size()) {
                List batch = processInstancesToSignalList.subList(currentIndex, Math.min(processInstancesToSignalList.size(), (int)((long)currentIndex + BATCH_SIZE)));
                CommandContext ctx = new CommandContext();
                ctx.setData("deploymentId", (Object)runtimeManager.getIdentifier());
                ctx.setData("processInstanceIds", new ArrayList(batch));
                ctx.setData("Signal", (Object)actualSignalType);
                ctx.setData("Event", event);
                executorService.scheduleRequest(BatchAsyncSignalEventCommand.class.getName(), ctx);
                currentIndex = (int)((long)currentIndex + BATCH_SIZE);
            }
        } else {
            Iterator iterator = processInstancesToSignalList.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                try {
                    this.getKnowledgeRuntime().getProcessInstance(id);
                }
                catch (IllegalStateException batch) {
                }
                catch (RuntimeException e) {
                    logger.warn("Exception when loading process instance for signal '{}', instance with id {} will not be signaled", (Object)e.getMessage(), (Object)id);
                }
            }
            super.signalEvent(actualSignalType, event);
        }
    }
}

