/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.Wrapped;
import org.kie.server.api.model.instance.TaskAttachment;
import org.kie.server.api.model.instance.TaskAttachmentList;
import org.kie.server.api.model.instance.TaskComment;
import org.kie.server.api.model.instance.TaskCommentList;
import org.kie.server.api.model.instance.TaskEventInstance;
import org.kie.server.api.model.instance.TaskEventInstanceList;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.api.model.instance.TaskSummary;
import org.kie.server.api.model.instance.TaskSummaryList;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.UserTaskServicesClient;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class UserTaskServicesClientImpl
extends AbstractKieServicesClientImpl
implements UserTaskServicesClient {
    public UserTaskServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public UserTaskServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public void activateTask(String containerId, Long taskId, String userId) {
        if (this.config.isRest()) {
            this.sendTaskOperation(containerId, taskId, "containers/{containerId}/tasks/{taskInstanceId}/states/activated", this.getUserQueryStr(userId));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "activate", new Object[]{containerId, taskId, userId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void claimTask(String containerId, Long taskId, String userId) {
        if (this.config.isRest()) {
            this.sendTaskOperation(containerId, taskId, "containers/{containerId}/tasks/{taskInstanceId}/states/claimed", this.getUserQueryStr(userId));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "claim", new Object[]{containerId, taskId, userId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void completeTask(String containerId, Long taskId, String userId, Map<String, Object> params) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/states/completed", valuesMap) + this.getUserQueryStr(userId), params, String.class, this.getHeaders(null));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "complete", this.serialize(this.safeMap(params)), this.marshaller.getFormat().getType(), new Object[]{containerId, taskId, userId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void completeAutoProgress(String containerId, Long taskId, String userId, Map<String, Object> params) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            String userQuery = this.getUserQueryStr(userId);
            StringBuilder queryString = new StringBuilder(userQuery);
            if (queryString.length() == 0) {
                queryString.append("?");
            } else {
                queryString.append("&");
            }
            queryString.append("auto-progress=true");
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/states/completed", valuesMap) + queryString.toString(), params, String.class, this.getHeaders(null));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "completeAutoProgress", this.serialize(this.safeMap(params)), this.marshaller.getFormat().getType(), new Object[]{containerId, taskId, userId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void delegateTask(String containerId, Long taskId, String userId, String targetUserId) {
        if (this.config.isRest()) {
            this.sendTaskOperation(containerId, taskId, "containers/{containerId}/tasks/{taskInstanceId}/states/delegated", this.getUserAndAdditionalParam(userId, "targetUser", targetUserId));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "delegate", new Object[]{containerId, taskId, userId, targetUserId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void exitTask(String containerId, Long taskId, String userId) {
        if (this.config.isRest()) {
            this.sendTaskOperation(containerId, taskId, "containers/{containerId}/tasks/{taskInstanceId}/states/exited", this.getUserQueryStr(userId));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "exit", new Object[]{containerId, taskId, userId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void failTask(String containerId, Long taskId, String userId, Map<String, Object> params) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/states/failed", valuesMap) + this.getUserQueryStr(userId), params, String.class, this.getHeaders(null));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "fail", this.serialize(this.safeMap(params)), this.marshaller.getFormat().getType(), new Object[]{containerId, taskId, userId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void forwardTask(String containerId, Long taskId, String userId, String targetEntityId) {
        if (this.config.isRest()) {
            this.sendTaskOperation(containerId, taskId, "containers/{containerId}/tasks/{taskInstanceId}/states/forwarded", this.getUserAndAdditionalParam(userId, "targetUser", targetEntityId));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "forward", new Object[]{containerId, taskId, userId, targetEntityId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void releaseTask(String containerId, Long taskId, String userId) {
        if (this.config.isRest()) {
            this.sendTaskOperation(containerId, taskId, "containers/{containerId}/tasks/{taskInstanceId}/states/released", this.getUserQueryStr(userId));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "release", new Object[]{containerId, taskId, userId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void resumeTask(String containerId, Long taskId, String userId) {
        if (this.config.isRest()) {
            this.sendTaskOperation(containerId, taskId, "containers/{containerId}/tasks/{taskInstanceId}/states/resumed", this.getUserQueryStr(userId));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "resume", new Object[]{containerId, taskId, userId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void skipTask(String containerId, Long taskId, String userId) {
        if (this.config.isRest()) {
            this.sendTaskOperation(containerId, taskId, "containers/{containerId}/tasks/{taskInstanceId}/states/skipped", this.getUserQueryStr(userId));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "skip", new Object[]{containerId, taskId, userId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void startTask(String containerId, Long taskId, String userId) {
        if (this.config.isRest()) {
            this.sendTaskOperation(containerId, taskId, "containers/{containerId}/tasks/{taskInstanceId}/states/started", this.getUserQueryStr(userId));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "start", new Object[]{containerId, taskId, userId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void stopTask(String containerId, Long taskId, String userId) {
        if (this.config.isRest()) {
            this.sendTaskOperation(containerId, taskId, "containers/{containerId}/tasks/{taskInstanceId}/states/stopped", this.getUserQueryStr(userId));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "stop", new Object[]{containerId, taskId, userId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void suspendTask(String containerId, Long taskId, String userId) {
        if (this.config.isRest()) {
            this.sendTaskOperation(containerId, taskId, "containers/{containerId}/tasks/{taskInstanceId}/states/suspended", this.getUserQueryStr(userId));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "suspend", new Object[]{containerId, taskId, userId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void nominateTask(String containerId, Long taskId, String userId, List<String> potentialOwners) {
        if (this.config.isRest()) {
            this.sendTaskOperation(containerId, taskId, "containers/{containerId}/tasks/{taskInstanceId}/states/nominated", this.getUserAndAdditionalParams(userId, "potOwner", potentialOwners));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "nominate", new Object[]{containerId, taskId, userId, potentialOwners})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void setTaskPriority(String containerId, Long taskId, int priority) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/priority", valuesMap), priority, String.class, this.getHeaders(null));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "setPriority", this.serialize(priority), this.marshaller.getFormat().getType(), new Object[]{containerId, taskId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void setTaskExpirationDate(String containerId, Long taskId, Date date) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/expiration", valuesMap), this.serialize(date), String.class, this.getHeaders(null));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "setExpirationDate", this.serialize(date), this.marshaller.getFormat().getType(), new Object[]{containerId, taskId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void setTaskSkipable(String containerId, Long taskId, boolean skipable) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/skipable", valuesMap), this.serialize(skipable), String.class, this.getHeaders(null));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "setSkipable", this.serialize(skipable), this.marshaller.getFormat().getType(), new Object[]{containerId, taskId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void setTaskName(String containerId, Long taskId, String name) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/name", valuesMap), this.serialize(name), String.class, this.getHeaders(null));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "setName", this.serialize(name), this.marshaller.getFormat().getType(), new Object[]{containerId, taskId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void setTaskDescription(String containerId, Long taskId, String description) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/description", valuesMap), this.serialize(description), String.class, this.getHeaders(null));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "setDescription", this.serialize(description), this.marshaller.getFormat().getType(), new Object[]{containerId, taskId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public Long saveTaskContent(String containerId, Long taskId, Map<String, Object> values) {
        Object contentId = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            contentId = this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/contents/output", valuesMap), values, Object.class, this.getHeaders(null));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "saveContent", this.serialize(values), this.marshaller.getFormat().getType(), new Object[]{containerId, taskId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            contentId = this.deserialize((String)response.getResult(), Object.class);
        }
        if (contentId instanceof Wrapped) {
            return (Long)((Wrapped)contentId).unwrap();
        }
        return ((Number)contentId).longValue();
    }

    @Override
    public Map<String, Object> getTaskOutputContentByTaskId(String containerId, Long taskId) {
        Object variables = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            variables = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/contents/output", valuesMap), Object.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "getTaskOutputContentByTaskId", this.marshaller.getFormat().getType(), new Object[]{containerId, taskId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            variables = this.deserialize((String)response.getResult(), Object.class);
        }
        if (variables instanceof Wrapped) {
            return (Map)((Wrapped)variables).unwrap();
        }
        return (Map)variables;
    }

    @Override
    public Map<String, Object> getTaskInputContentByTaskId(String containerId, Long taskId) {
        Object variables = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            variables = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/contents/input", valuesMap), Object.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "getTaskInputContentByTaskId", this.marshaller.getFormat().getType(), new Object[]{containerId, taskId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            variables = this.deserialize((String)response.getResult(), Object.class);
        }
        if (variables instanceof Wrapped) {
            return (Map)((Wrapped)variables).unwrap();
        }
        return (Map)variables;
    }

    @Override
    public void deleteTaskContent(String containerId, Long taskId, Long contentId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            valuesMap.put("contentId", contentId);
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/contents/{contentId}", valuesMap), null);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "deleteContent", new Object[]{containerId, taskId, contentId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public Long addTaskComment(String containerId, Long taskId, String text, String addedBy, Date addedOn) {
        Object commentId = null;
        TaskComment taskComment = TaskComment.builder().text(text).addedBy(addedBy).addedAt(addedOn).build();
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            commentId = this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/comments", valuesMap), taskComment, Object.class, this.getHeaders(taskComment));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "addComment", this.serialize(taskComment), this.marshaller.getFormat().getType(), new Object[]{containerId, taskId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            commentId = this.deserialize((String)response.getResult(), Object.class);
        }
        if (commentId instanceof Wrapped) {
            return (Long)((Wrapped)commentId).unwrap();
        }
        return ((Number)commentId).longValue();
    }

    @Override
    public void deleteTaskComment(String containerId, Long taskId, Long commentId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            valuesMap.put("commentId", commentId);
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/comments/{commentId}", valuesMap), null);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "deleteComment", new Object[]{containerId, taskId, commentId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public List<TaskComment> getTaskCommentsByTaskId(String containerId, Long taskId) {
        TaskCommentList commentList = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            commentList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/comments", valuesMap), TaskCommentList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "getCommentsByTaskId", this.marshaller.getFormat().getType(), new Object[]{containerId, taskId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            commentList = this.deserialize((String)response.getResult(), TaskCommentList.class);
        }
        if (commentList.getTasks() != null) {
            return Arrays.asList(commentList.getTasks());
        }
        return Collections.emptyList();
    }

    @Override
    public TaskComment getTaskCommentById(String containerId, Long taskId, Long commentId) {
        TaskComment taskComment = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            valuesMap.put("commentId", commentId);
            taskComment = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/comments/{commentId}", valuesMap), TaskComment.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "getCommentById", this.marshaller.getFormat().getType(), new Object[]{containerId, taskId, commentId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            taskComment = this.deserialize((String)response.getResult(), TaskComment.class);
        }
        return taskComment;
    }

    @Override
    public Long addTaskAttachment(String containerId, Long taskId, String userId, String name, Object attachment) {
        Object attachmentId = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            attachmentId = this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/attachments", valuesMap) + this.getUserAndAdditionalParam(userId, "name", name), attachment, Object.class, this.getHeaders(null));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "addAttachment", this.serialize(attachment), this.marshaller.getFormat().getType(), new Object[]{containerId, taskId, userId, name})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            attachmentId = this.deserialize((String)response.getResult(), Object.class);
        }
        if (attachmentId instanceof Wrapped) {
            return (Long)((Wrapped)attachmentId).unwrap();
        }
        return ((Number)attachmentId).longValue();
    }

    @Override
    public void deleteTaskAttachment(String containerId, Long taskId, Long attachmentId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            valuesMap.put("attachmentId", attachmentId);
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/attachments/{attachmentId}", valuesMap), null);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "deleteAttachment", new Object[]{containerId, taskId, attachmentId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public TaskAttachment getTaskAttachmentById(String containerId, Long taskId, Long attachmentId) {
        TaskAttachment attachment = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            valuesMap.put("attachmentId", attachmentId);
            attachment = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/attachments/{attachmentId}", valuesMap), TaskAttachment.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "getAttachmentById", this.marshaller.getFormat().getType(), new Object[]{containerId, taskId, attachmentId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            attachment = this.deserialize((String)response.getResult(), TaskAttachment.class);
        }
        return attachment;
    }

    @Override
    public Object getTaskAttachmentContentById(String containerId, Long taskId, Long attachmentId) {
        Object result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            valuesMap.put("attachmentId", attachmentId);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/attachments/{attachmentId}/content", valuesMap), Object.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "getAttachmentContentById", this.marshaller.getFormat().getType(), new Object[]{containerId, taskId, attachmentId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = this.deserialize((String)response.getResult(), Object.class);
        }
        if (result instanceof Wrapped) {
            return ((Wrapped)result).unwrap();
        }
        return result;
    }

    @Override
    public List<TaskAttachment> getTaskAttachmentsByTaskId(String containerId, Long taskId) {
        TaskAttachmentList attachmentList = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            attachmentList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/attachments", valuesMap), TaskAttachmentList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "getAttachmentsByTaskId", this.marshaller.getFormat().getType(), new Object[]{containerId, taskId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            attachmentList = this.deserialize((String)response.getResult(), TaskAttachmentList.class);
        }
        if (attachmentList.getTasks() != null) {
            return Arrays.asList(attachmentList.getTasks());
        }
        return Collections.emptyList();
    }

    @Override
    public TaskInstance getTaskInstance(String containerId, Long taskId) {
        TaskInstance result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}", valuesMap), TaskInstance.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "getTask", this.marshaller.getFormat().getType(), new Object[]{containerId, taskId, false, false, false})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = this.deserialize((String)response.getResult(), TaskInstance.class);
        }
        return result;
    }

    @Override
    public TaskInstance getTaskInstance(String containerId, Long taskId, boolean withInputs, boolean withOutputs, boolean withAssignments) {
        TaskInstance result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            StringBuilder queryString = new StringBuilder();
            queryString.append("?withInputData").append("=").append(withInputs).append("&withOutputData").append("=").append(withOutputs).append("&withAssignments").append("=").append(withAssignments);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}", valuesMap) + queryString.toString(), TaskInstance.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "getTask", this.marshaller.getFormat().getType(), new Object[]{containerId, taskId, withInputs, withOutputs, withAssignments})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = this.deserialize((String)response.getResult(), TaskInstance.class);
        }
        return result;
    }

    @Override
    public TaskInstance findTaskByWorkItemId(Long workItemId) {
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("workItemId", workItemId);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/tasks/instances/workitem/{workItemId}", valuesMap), TaskInstance.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getTaskByWorkItemId", new Object[]{workItemId})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (TaskInstance)response.getResult();
    }

    @Override
    public TaskInstance findTaskById(Long taskId) {
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("taskInstanceId", taskId);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/tasks/instances/{taskInstanceId}", valuesMap), TaskInstance.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getTaskById", new Object[]{taskId})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (TaskInstance)response.getResult();
    }

    @Override
    public List<TaskSummary> findTasksAssignedAsBusinessAdministrator(String userId, Integer page, Integer pageSize) {
        return this.findTasksAssignedAsBusinessAdministrator(userId, page, pageSize, "", true);
    }

    @Override
    public List<TaskSummary> findTasksAssignedAsBusinessAdministrator(String userId, List<String> status, Integer page, Integer pageSize) {
        return this.findTasksAssignedAsBusinessAdministrator(userId, status, page, pageSize, "", true);
    }

    @Override
    public List<TaskSummary> findTasksAssignedAsPotentialOwner(String userId, Integer page, Integer pageSize) {
        return this.findTasksAssignedAsPotentialOwner(userId, page, pageSize, "", true);
    }

    @Override
    public List<TaskSummary> findTasksAssignedAsPotentialOwner(String userId, List<String> status, Integer page, Integer pageSize) {
        return this.findTasksAssignedAsPotentialOwner(userId, status, page, pageSize, "", true);
    }

    @Override
    public List<TaskSummary> findTasksAssignedAsPotentialOwner(String userId, String filter, List<String> status, Integer page, Integer pageSize) {
        return this.findTasksAssignedAsPotentialOwner(userId, filter, status, page, pageSize, "", true);
    }

    @Override
    public List<TaskSummary> findTasksAssignedAsPotentialOwner(String userId, List<String> groups, List<String> status, Integer page, Integer pageSize) {
        return this.findTasksAssignedAsPotentialOwner(userId, groups, status, page, pageSize, "", true);
    }

    @Override
    public List<TaskSummary> findTasksOwned(String userId, Integer page, Integer pageSize) {
        return this.findTasksOwned(userId, page, pageSize, "", true);
    }

    @Override
    public List<TaskSummary> findTasksOwned(String userId, List<String> status, Integer page, Integer pageSize) {
        return this.findTasksOwned(userId, status, page, pageSize, "", true);
    }

    @Override
    public List<TaskSummary> findTasksByStatusByProcessInstanceId(Long processInstanceId, List<String> status, Integer page, Integer pageSize) {
        return this.findTasksByStatusByProcessInstanceId(processInstanceId, status, page, pageSize, "", true);
    }

    @Override
    public List<TaskSummary> findTasks(String userId, Integer page, Integer pageSize) {
        return this.findTasks(userId, page, pageSize, "", true);
    }

    @Override
    public List<TaskEventInstance> findTaskEvents(Long taskId, Integer page, Integer pageSize) {
        return this.findTaskEvents(taskId, page, pageSize, "", true);
    }

    @Override
    public List<TaskSummary> findTasksByVariable(String userId, String variableName, List<String> status, Integer page, Integer pageSize) {
        return this.findTasksByVariable(userId, variableName, status, page, pageSize, "", true);
    }

    @Override
    public List<TaskSummary> findTasksByVariableAndValue(String userId, String variableName, String variableValue, List<String> status, Integer page, Integer pageSize) {
        return this.findTasksByVariableAndValue(userId, variableName, variableValue, status, page, pageSize, "", true);
    }

    @Override
    public List<TaskSummary> findTasksAssignedAsBusinessAdministrator(String userId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        TaskSummaryList taskSummaryList = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getUserAndPagingQueryString(userId, page, pageSize) + "&sort=" + sort + "&sortOrder=" + sortOrder;
            taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/tasks/instances/admins", valuesMap) + queryString, TaskSummaryList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getTasksAssignedAsBusinessAdministratorByStatus", new Object[]{new ArrayList(), userId, page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            taskSummaryList = (TaskSummaryList)response.getResult();
        }
        if (taskSummaryList != null && taskSummaryList.getTasks() != null) {
            return Arrays.asList(taskSummaryList.getTasks());
        }
        return Collections.emptyList();
    }

    @Override
    public List<TaskSummary> findTasksAssignedAsBusinessAdministrator(String userId, List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        TaskSummaryList taskSummaryList = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String userQuery = this.getUserQueryStr(userId);
            String statusQuery = this.getAdditionalParams(userQuery, "status", status);
            String queryString = this.getPagingQueryString(statusQuery, page, pageSize) + "&sort=" + sort + "&sortOrder=" + sortOrder;
            taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/tasks/instances/admins", valuesMap) + queryString, TaskSummaryList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getTasksAssignedAsBusinessAdministratorByStatus", new Object[]{this.safeList(status), userId, page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            taskSummaryList = (TaskSummaryList)response.getResult();
        }
        if (taskSummaryList != null && taskSummaryList.getTasks() != null) {
            return Arrays.asList(taskSummaryList.getTasks());
        }
        return Collections.emptyList();
    }

    @Override
    public List<TaskSummary> findTasksAssignedAsPotentialOwner(String userId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        TaskSummaryList taskSummaryList = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getUserAndPagingQueryString(userId, page, pageSize) + "&sort=" + sort + "&sortOrder=" + sortOrder;
            taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/tasks/instances/pot-owners", valuesMap) + queryString, TaskSummaryList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getTasksAssignedAsPotentialOwner", new Object[]{new ArrayList(), new ArrayList(), userId, page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            taskSummaryList = (TaskSummaryList)response.getResult();
        }
        if (taskSummaryList != null && taskSummaryList.getTasks() != null) {
            return Arrays.asList(taskSummaryList.getTasks());
        }
        return Collections.emptyList();
    }

    @Override
    public List<TaskSummary> findTasksAssignedAsPotentialOwner(String userId, List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        TaskSummaryList taskSummaryList = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String userQuery = this.getUserQueryStr(userId);
            String statusQuery = this.getAdditionalParams(userQuery, "status", status);
            String queryString = this.getPagingQueryString(statusQuery, page, pageSize) + "&sort=" + sort + "&sortOrder=" + sortOrder;
            taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/tasks/instances/pot-owners", valuesMap) + queryString, TaskSummaryList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getTasksAssignedAsPotentialOwner", new Object[]{this.safeList(status), new ArrayList(), userId, page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            taskSummaryList = (TaskSummaryList)response.getResult();
        }
        if (taskSummaryList != null && taskSummaryList.getTasks() != null) {
            return Arrays.asList(taskSummaryList.getTasks());
        }
        return Collections.emptyList();
    }

    @Override
    public List<TaskSummary> findTasksAssignedAsPotentialOwner(String userId, String filter, List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        TaskSummaryList taskSummaryList = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String userQuery = this.getUserQueryStr(userId);
            String statusQuery = this.getAdditionalParams(userQuery, "status", status);
            String queryString = this.getPagingQueryString(statusQuery, page, pageSize) + "&sort=" + sort + "&sortOrder=" + sortOrder + "&filter=" + filter;
            taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/tasks/instances/pot-owners", valuesMap) + queryString, TaskSummaryList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getTasksAssignedAsPotentialOwner", new Object[]{this.safeList(status), new ArrayList(), userId, page, pageSize, sort, sortOrder, filter})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            taskSummaryList = (TaskSummaryList)response.getResult();
        }
        if (taskSummaryList != null && taskSummaryList.getTasks() != null) {
            return Arrays.asList(taskSummaryList.getTasks());
        }
        return Collections.emptyList();
    }

    @Override
    public List<TaskSummary> findTasksAssignedAsPotentialOwner(String userId, List<String> groups, List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        TaskSummaryList taskSummaryList = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String userQuery = this.getUserQueryStr(userId);
            String statusQuery = this.getAdditionalParams(userQuery, "status", status);
            String groupsQuery = this.getAdditionalParams(statusQuery, "groups", groups);
            String queryString = this.getPagingQueryString(groupsQuery, page, pageSize) + "&sort=" + sort + "&sortOrder=" + sortOrder;
            taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/tasks/instances/pot-owners", valuesMap) + queryString, TaskSummaryList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getTasksAssignedAsPotentialOwner", new Object[]{this.safeList(status), this.safeList(groups), userId, page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            taskSummaryList = (TaskSummaryList)response.getResult();
        }
        if (taskSummaryList != null && taskSummaryList.getTasks() != null) {
            return Arrays.asList(taskSummaryList.getTasks());
        }
        return Collections.emptyList();
    }

    @Override
    public List<TaskSummary> findTasksOwned(String userId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        TaskSummaryList taskSummaryList = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getUserAndPagingQueryString(userId, page, pageSize) + "&sort=" + sort + "&sortOrder=" + sortOrder;
            taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/tasks/instances/owners", valuesMap) + queryString, TaskSummaryList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getTasksOwnedByStatus", new Object[]{new ArrayList(), userId, page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            taskSummaryList = (TaskSummaryList)response.getResult();
        }
        if (taskSummaryList != null && taskSummaryList.getTasks() != null) {
            return Arrays.asList(taskSummaryList.getTasks());
        }
        return Collections.emptyList();
    }

    @Override
    public List<TaskSummary> findTasksOwned(String userId, List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        TaskSummaryList taskSummaryList = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String userQuery = this.getUserQueryStr(userId);
            String statusQuery = this.getAdditionalParams(userQuery, "status", status);
            String queryString = this.getPagingQueryString(statusQuery, page, pageSize) + "&sort=" + sort + "&sortOrder=" + sortOrder;
            taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/tasks/instances/owners", valuesMap) + queryString, TaskSummaryList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getTasksOwnedByStatus", new Object[]{this.safeList(status), userId, page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            taskSummaryList = (TaskSummaryList)response.getResult();
        }
        if (taskSummaryList != null && taskSummaryList.getTasks() != null) {
            return Arrays.asList(taskSummaryList.getTasks());
        }
        return Collections.emptyList();
    }

    @Override
    public List<TaskSummary> findTasksByStatusByProcessInstanceId(Long processInstanceId, List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        TaskSummaryList taskSummaryList = null;
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("processInstanceId", processInstanceId);
            String statusQuery = this.getAdditionalParams("", "status", status);
            String queryString = this.getPagingQueryString(statusQuery, page, pageSize) + "&sort=" + sort + "&sortOrder=" + sortOrder;
            taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/tasks/instances/process/{processInstanceId}", valuesMap) + queryString, TaskSummaryList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getTasksByStatusByProcessInstanceId", new Object[]{processInstanceId, this.safeList(status), page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            taskSummaryList = (TaskSummaryList)response.getResult();
        }
        if (taskSummaryList != null && taskSummaryList.getTasks() != null) {
            return Arrays.asList(taskSummaryList.getTasks());
        }
        return Collections.emptyList();
    }

    @Override
    public List<TaskSummary> findTasks(String userId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        TaskSummaryList taskSummaryList = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getUserAndPagingQueryString(userId, page, pageSize) + "&sort=" + sort + "&sortOrder=" + sortOrder;
            taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/tasks/instances", valuesMap) + queryString, TaskSummaryList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getAllAuditTask", new Object[]{userId, page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            taskSummaryList = (TaskSummaryList)response.getResult();
        }
        if (taskSummaryList != null && taskSummaryList.getTasks() != null) {
            return Arrays.asList(taskSummaryList.getTasks());
        }
        return Collections.emptyList();
    }

    @Override
    public List<TaskEventInstance> findTaskEvents(Long taskId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        TaskEventInstanceList taskSummaryList = null;
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("taskInstanceId", taskId);
            String queryString = this.getPagingQueryString("?sort=" + sort + "&sortOrder=" + sortOrder, page, pageSize);
            taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/tasks/instances/{taskInstanceId}/events", valuesMap) + queryString, TaskEventInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getTaskEvents", new Object[]{taskId, page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            taskSummaryList = (TaskEventInstanceList)response.getResult();
        }
        if (taskSummaryList != null && taskSummaryList.getTaskEvents() != null) {
            return Arrays.asList(taskSummaryList.getTaskEvents());
        }
        return Collections.emptyList();
    }

    @Override
    public List<TaskSummary> findTasksByVariable(String userId, String variableName, List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        TaskSummaryList result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("varName", variableName);
            String userQuery = this.getUserQueryStr(userId);
            String statusQuery = this.getAdditionalParams(userQuery, "status", status);
            String queryString = this.getPagingQueryString(statusQuery, page, pageSize) + "&sort=" + sort + "&sortOrder=" + sortOrder;
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/tasks/instances/variables/{varName}", valuesMap) + queryString, TaskSummaryList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getTasksByVariables", new Object[]{userId, variableName, "", this.safeList(status), page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (TaskSummaryList)response.getResult();
        }
        if (result != null && result.getTasks() != null) {
            return Arrays.asList(result.getTasks());
        }
        return Collections.emptyList();
    }

    @Override
    public List<TaskSummary> findTasksByVariableAndValue(String userId, String variableName, String variableValue, List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        TaskSummaryList result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("varName", variableName);
            String userQuery = this.getUserQueryStr(userId);
            String statusQuery = this.getAdditionalParams(userQuery, "status", status);
            String queryString = this.getPagingQueryString(statusQuery, page, pageSize) + "&sort=" + sort + "&sortOrder=" + sortOrder;
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/tasks/instances/variables/{varName}", valuesMap) + queryString + "&varValue=" + variableValue, TaskSummaryList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getTasksByVariables", new Object[]{userId, variableName, variableValue, this.safeList(status), page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (TaskSummaryList)response.getResult();
        }
        if (result != null && result.getTasks() != null) {
            return Arrays.asList(result.getTasks());
        }
        return Collections.emptyList();
    }

    @Override
    public List<TaskEventInstance> findTaskEvents(String containerId, Long taskId, Integer page, Integer pageSize) {
        return this.findTaskEvents(containerId, taskId, page, pageSize, "", true);
    }

    @Override
    public List<TaskEventInstance> findTaskEvents(String containerId, Long taskId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        TaskEventInstanceList taskSummaryList = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            String queryString = this.getPagingQueryString("?sort=" + sort + "&sortOrder=" + sortOrder, page, pageSize);
            taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}/events", valuesMap) + queryString, TaskEventInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getTaskEvents", new Object[]{taskId, page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            taskSummaryList = (TaskEventInstanceList)response.getResult();
        }
        if (taskSummaryList != null && taskSummaryList.getTaskEvents() != null) {
            return Arrays.asList(taskSummaryList.getTaskEvents());
        }
        return Collections.emptyList();
    }

    @Override
    public void updateTask(String containerId, Long taskId, String userId, TaskInstance updatedTask) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/tasks/{taskInstanceId}", valuesMap) + this.getUserQueryStr(userId), updatedTask, String.class, this.getHeaders(null));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskService", "update", this.serialize(updatedTask), this.marshaller.getFormat().getType(), new Object[]{containerId, taskId, userId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }
}

