/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.core.api.DMNMessageManager;
import org.kie.dmn.core.util.DefaultDMNMessagesManager;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;

public class DMNResultImpl
implements DMNResult,
DMNMessageManager {
    private DMNContext context;
    private DMNMessageManager messages;
    private Map<String, DMNDecisionResult> decisionResults;
    private final DMNModel model;

    public DMNResultImpl(DMNModel model) {
        this.model = model;
        this.messages = new DefaultDMNMessagesManager();
        this.decisionResults = new HashMap<String, DMNDecisionResult>();
    }

    public void setContext(DMNContext context) {
        this.context = context;
    }

    public DMNContext getContext() {
        return this.context;
    }

    public List<DMNMessage> getMessages() {
        return this.messages.getMessages();
    }

    @Override
    public void addAll(List<? extends DMNMessage> messages) {
        this.messages.addAll(messages);
    }

    @Override
    public DMNMessage addMessage(DMNMessage msg) {
        return this.messages.addMessage(msg);
    }

    @Override
    public DMNMessage addMessage(DMNMessage.Severity severity, String message, DMNMessageType messageType, DMNModelInstrumentedBase source) {
        return this.messages.addMessage(severity, message, messageType, source);
    }

    @Override
    public DMNMessage addMessage(DMNMessage.Severity severity, String message, DMNMessageType messageType, DMNModelInstrumentedBase source, Throwable exception) {
        return this.messages.addMessage(severity, message, messageType, source, exception);
    }

    public List<DMNMessage> getMessages(DMNMessage.Severity ... sevs) {
        return this.messages.getMessages(sevs);
    }

    @Override
    public DMNMessage addMessage(DMNMessage.Severity severity, String message, DMNMessageType messageType, DMNModelInstrumentedBase source, FEELEvent feelEvent) {
        return this.messages.addMessage(severity, message, messageType, source, feelEvent);
    }

    public boolean hasErrors() {
        return this.messages.hasErrors();
    }

    public List<DMNDecisionResult> getDecisionResults() {
        return new ArrayList<DMNDecisionResult>(this.decisionResults.values());
    }

    public DMNDecisionResult getDecisionResultByName(String name) {
        return this.decisionResults.values().stream().filter(dr -> dr.getDecisionName().equals(name)).findFirst().orElse(null);
    }

    public DMNDecisionResult getDecisionResultById(String id) {
        return this.decisionResults.get(id);
    }

    public void addDecisionResult(DMNDecisionResult result) {
        this.decisionResults.put(result.getDecisionId(), result);
    }

    public String toString() {
        return "DMNResultImpl{context=" + this.context + ", messages=" + this.messages + '}';
    }

    public DMNModel getModel() {
        return this.model;
    }

    @Override
    public void addAllUnfiltered(List<? extends DMNMessage> messages) {
        this.messages.addAllUnfiltered(messages);
    }
}

