/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.internal.utils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNEvaluationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DMNEvaluationUtils.class);

    public static DMNEvaluationResult evaluate(DMNRuntime dmnRuntime, String modelNamespace, String modelName, Map<String, Object> inputContextValues, List<String> decisionNames, List<String> decisionIds, String decisionServiceName) {
        Supplier<DMNContext> dmnContextProducer = () -> {
            DMNContext ctx = dmnRuntime.newContext();
            for (Map.Entry entry : inputContextValues.entrySet()) {
                ctx.set((String)entry.getKey(), entry.getValue());
            }
            return ctx;
        };
        return DMNEvaluationUtils.evaluate(dmnRuntime, modelNamespace, modelName, dmnContextProducer, decisionNames, decisionIds, decisionServiceName);
    }

    public static DMNEvaluationResult evaluate(DMNRuntime dmnRuntime, String modelNamespace, String modelName, Supplier<DMNContext> dmnContextProducer, List<String> decisionNames, List<String> decisionIds, String decisionServiceName) {
        DMNModel model;
        if (modelName == null) {
            if (dmnRuntime.getModels().size() > 1) {
                throw new RuntimeException("more than one (default) model");
            }
            model = (DMNModel)dmnRuntime.getModels().get(0);
        } else {
            model = dmnRuntime.getModel(modelNamespace, modelName);
        }
        if (model == null) {
            throw new RuntimeException("Unable to locate DMN Model to evaluate");
        }
        LOG.debug("Will use model: {}", (Object)model);
        DMNContext dmnContext = dmnContextProducer.get();
        LOG.debug("Will use dmnContext: {}", (Object)dmnContext);
        DMNResult result = null;
        List<String> names = Optional.ofNullable(decisionNames).orElse(Collections.emptyList());
        List<String> ids = Optional.ofNullable(decisionIds).orElse(Collections.emptyList());
        if (decisionServiceName == null && names.isEmpty() && ids.isEmpty()) {
            LOG.debug("Invoking evaluateAll...");
            result = dmnRuntime.evaluateAll(model, dmnContext);
        } else if (decisionServiceName != null && names.isEmpty() && ids.isEmpty()) {
            LOG.debug("Invoking evaluateDecisionService using decisionServiceName: {}", (Object)decisionServiceName);
            result = dmnRuntime.evaluateDecisionService(model, dmnContext, decisionServiceName);
        } else if (!names.isEmpty() && ids.isEmpty()) {
            LOG.debug("Invoking evaluateDecisionByName using {}", names);
            result = dmnRuntime.evaluateByName(model, dmnContext, names.toArray(new String[0]));
        } else if (!ids.isEmpty() && names.isEmpty()) {
            LOG.debug("Invoking evaluateDecisionById using {}", ids);
            result = dmnRuntime.evaluateById(model, dmnContext, ids.toArray(new String[0]));
        } else {
            LOG.debug("Not supported case");
            throw new RuntimeException("Unable to locate DMN Decision to evaluate");
        }
        LOG.debug("Result:");
        LOG.debug("{}", (Object)result);
        LOG.debug("{}", (Object)result.getContext());
        LOG.debug("{}", (Object)result.getDecisionResults());
        LOG.debug("{}", (Object)result.getMessages());
        return new DMNEvaluationResult(model, dmnContext, result);
    }

    private DMNEvaluationUtils() {
    }

    public static class DMNEvaluationResult {
        public final DMNModel model;
        public final DMNContext inputContext;
        public final DMNResult result;

        public DMNEvaluationResult(DMNModel model, DMNContext inputContext, DMNResult result) {
            this.model = model;
            this.inputContext = inputContext;
            this.result = result;
        }
    }
}

