/*
 * Decompiled with CFR 0.152.
 */
package org.drools.constraint.parser.ast.expr;

import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithArguments;
import com.github.javaparser.ast.nodeTypes.NodeWithOptionalScope;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.metamodel.OptionalProperty;
import com.github.javaparser.resolution.Resolvable;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.utils.Utils;
import java.util.Optional;
import org.drools.constraint.parser.ast.visitor.DrlGenericVisitor;
import org.drools.constraint.parser.ast.visitor.DrlVoidVisitor;

public class NullSafeMethodCallExpr
extends Expression
implements NodeWithTypeArguments<NullSafeMethodCallExpr>,
NodeWithArguments<NullSafeMethodCallExpr>,
NodeWithSimpleName<NullSafeMethodCallExpr>,
NodeWithOptionalScope<NullSafeMethodCallExpr>,
Resolvable<ResolvedMethodDeclaration> {
    @OptionalProperty
    private Expression scope;
    @OptionalProperty
    private NodeList<Type> typeArguments;
    private SimpleName name;
    private NodeList<Expression> arguments;

    public NullSafeMethodCallExpr() {
        this(null, null, null, new SimpleName(), (NodeList<Expression>)new NodeList());
    }

    public NullSafeMethodCallExpr(String name, Expression ... arguments) {
        this(null, null, null, new SimpleName(name), (NodeList<Expression>)new NodeList((Node[])arguments));
    }

    public NullSafeMethodCallExpr(Expression scope, String name) {
        this(null, scope, null, new SimpleName(name), (NodeList<Expression>)new NodeList());
    }

    public NullSafeMethodCallExpr(Expression scope, SimpleName name) {
        this(null, scope, null, name, (NodeList<Expression>)new NodeList());
    }

    public NullSafeMethodCallExpr(Expression scope, String name, NodeList<Expression> arguments) {
        this(null, scope, null, new SimpleName(name), arguments);
    }

    public NullSafeMethodCallExpr(Expression scope, NodeList<Type> typeArguments, String name, NodeList<Expression> arguments) {
        this(null, scope, typeArguments, new SimpleName(name), arguments);
    }

    public NullSafeMethodCallExpr(Expression scope, SimpleName name, NodeList<Expression> arguments) {
        this(null, scope, null, name, arguments);
    }

    @AllFieldsConstructor
    public NullSafeMethodCallExpr(Expression scope, NodeList<Type> typeArguments, SimpleName name, NodeList<Expression> arguments) {
        this(null, scope, typeArguments, name, arguments);
    }

    public NullSafeMethodCallExpr(TokenRange tokenRange, Expression scope, NodeList<Type> typeArguments, SimpleName name, NodeList<Expression> arguments) {
        super(tokenRange);
        this.setScope(scope);
        this.setTypeArguments(typeArguments);
        this.setName(name);
        this.setArguments(arguments);
        this.customInitialization();
    }

    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return ((DrlGenericVisitor)v).visit(this, arg);
    }

    public <A> void accept(VoidVisitor<A> v, A arg) {
        ((DrlVoidVisitor)v).visit(this, arg);
    }

    public NodeList<Expression> getArguments() {
        return this.arguments;
    }

    public SimpleName getName() {
        return this.name;
    }

    public Optional<Expression> getScope() {
        return Optional.ofNullable(this.scope);
    }

    public NullSafeMethodCallExpr setArguments(NodeList<Expression> arguments) {
        Utils.assertNotNull(arguments);
        if (arguments == this.arguments) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.ARGUMENTS, this.arguments, arguments);
        if (this.arguments != null) {
            this.arguments.setParentNode(null);
        }
        this.arguments = arguments;
        this.setAsParentNodeOf(arguments);
        return this;
    }

    public NullSafeMethodCallExpr setName(SimpleName name) {
        Utils.assertNotNull((Object)name);
        if (name == this.name) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.NAME, this.name, name);
        if (this.name != null) {
            this.name.setParentNode(null);
        }
        this.name = name;
        this.setAsParentNodeOf((Node)name);
        return this;
    }

    public NullSafeMethodCallExpr setScope(Expression scope) {
        if (scope == this.scope) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.SCOPE, this.scope, scope);
        if (this.scope != null) {
            this.scope.setParentNode(null);
        }
        this.scope = scope;
        this.setAsParentNodeOf((Node)scope);
        return this;
    }

    public Optional<NodeList<Type>> getTypeArguments() {
        return Optional.ofNullable(this.typeArguments);
    }

    public NullSafeMethodCallExpr setTypeArguments(NodeList<Type> typeArguments) {
        if (typeArguments == this.typeArguments) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.TYPE_ARGUMENTS, this.typeArguments, typeArguments);
        if (this.typeArguments != null) {
            this.typeArguments.setParentNode(null);
        }
        this.typeArguments = typeArguments;
        this.setAsParentNodeOf(typeArguments);
        return this;
    }

    public boolean remove(Node node) {
        int i;
        if (node == null) {
            return false;
        }
        for (i = 0; i < this.arguments.size(); ++i) {
            if (this.arguments.get(i) != node) continue;
            this.arguments.remove(i);
            return true;
        }
        if (this.scope != null && node == this.scope) {
            this.removeScope();
            return true;
        }
        if (this.typeArguments != null) {
            for (i = 0; i < this.typeArguments.size(); ++i) {
                if (this.typeArguments.get(i) != node) continue;
                this.typeArguments.remove(i);
                return true;
            }
        }
        return super.remove(node);
    }

    public NullSafeMethodCallExpr removeScope() {
        return this.setScope(null);
    }

    public NullSafeMethodCallExpr clone() {
        return (NullSafeMethodCallExpr)((Object)this.accept((GenericVisitor)new CloneVisitor(), null));
    }

    public boolean replace(Node node, Node replacementNode) {
        int i;
        if (node == null) {
            return false;
        }
        for (i = 0; i < this.arguments.size(); ++i) {
            if (this.arguments.get(i) != node) continue;
            this.arguments.set(i, (Node)((Expression)replacementNode));
            return true;
        }
        if (node == this.name) {
            this.setName((SimpleName)replacementNode);
            return true;
        }
        if (this.scope != null && node == this.scope) {
            this.setScope((Expression)replacementNode);
            return true;
        }
        if (this.typeArguments != null) {
            for (i = 0; i < this.typeArguments.size(); ++i) {
                if (this.typeArguments.get(i) != node) continue;
                this.typeArguments.set(i, (Node)((Type)replacementNode));
                return true;
            }
        }
        return super.replace(node, replacementNode);
    }

    public ResolvedMethodDeclaration resolve() {
        return (ResolvedMethodDeclaration)this.getSymbolResolver().resolveDeclaration((Node)this, ResolvedMethodDeclaration.class);
    }

    @Deprecated
    public ResolvedMethodDeclaration resolveInvokedMethod() {
        return this.resolve();
    }
}

