/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.mining;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.ProbabilityNumberAdapter;
import org.dmg.pmml.mining.Segment;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.Removed;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="Segmentation", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "localTransformations", "segments"})
@Added(value=Version.PMML_4_0)
@JsonRootName(value="Segmentation")
@JsonPropertyOrder(value={"multipleModelMethod", "missingPredictionTreatment", "missingThreshold", "extensions", "localTransformations", "segments"})
public class Segmentation
extends PMMLObject
implements HasExtensions<Segmentation> {
    @XmlAttribute(name="multipleModelMethod", required=true)
    @JsonProperty(value="multipleModelMethod")
    private MultipleModelMethod multipleModelMethod;
    @XmlAttribute(name="missingPredictionTreatment")
    @Added(value=Version.PMML_4_4)
    @JsonProperty(value="missingPredictionTreatment")
    private MissingPredictionTreatment missingPredictionTreatment;
    @XmlAttribute(name="missingThreshold")
    @XmlJavaTypeAdapter(value=ProbabilityNumberAdapter.class)
    @Added(value=Version.PMML_4_4)
    @JsonProperty(value="missingThreshold")
    private Number missingThreshold;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_4")
    @Removed(value=Version.PMML_4_1)
    @JsonProperty(value="LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name="Segment", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="Segment")
    private List<Segment> segments;
    private static final Number DEFAULT_MISSING_THRESHOLD = new ProbabilityNumberAdapter().unmarshal("1");
    private static final long serialVersionUID = 0x4040002L;

    public Segmentation() {
    }

    @ValueConstructor
    public Segmentation(@Property(value="multipleModelMethod") MultipleModelMethod multipleModelMethod, @Property(value="segments") List<Segment> segments) {
        this.multipleModelMethod = multipleModelMethod;
        this.segments = segments;
    }

    public MultipleModelMethod getMultipleModelMethod() {
        return this.multipleModelMethod;
    }

    public Segmentation setMultipleModelMethod(@Property(value="multipleModelMethod") MultipleModelMethod multipleModelMethod) {
        this.multipleModelMethod = multipleModelMethod;
        return this;
    }

    public MissingPredictionTreatment getMissingPredictionTreatment() {
        if (this.missingPredictionTreatment == null) {
            return MissingPredictionTreatment.CONTINUE;
        }
        return this.missingPredictionTreatment;
    }

    public Segmentation setMissingPredictionTreatment(@Property(value="missingPredictionTreatment") MissingPredictionTreatment missingPredictionTreatment) {
        this.missingPredictionTreatment = missingPredictionTreatment;
        return this;
    }

    public Number getMissingThreshold() {
        if (this.missingThreshold == null) {
            return DEFAULT_MISSING_THRESHOLD;
        }
        return this.missingThreshold;
    }

    public Segmentation setMissingThreshold(@Property(value="missingThreshold") Number missingThreshold) {
        this.missingThreshold = missingThreshold;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Segmentation addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    public Segmentation setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public boolean hasSegments() {
        return this.segments != null && this.segments.size() > 0;
    }

    public List<Segment> getSegments() {
        if (this.segments == null) {
            this.segments = new ArrayList<Segment>();
        }
        return this.segments;
    }

    public Segmentation addSegments(Segment ... segments) {
        this.getSegments().addAll(Arrays.asList(segments));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getLocalTransformations());
            }
            if (status == VisitorAction.CONTINUE && this.hasSegments()) {
                status = PMMLObject.traverse(visitor, this.getSegments());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum MultipleModelMethod implements StringValue<MultipleModelMethod>
    {
        MAJORITY_VOTE("majorityVote"),
        WEIGHTED_MAJORITY_VOTE("weightedMajorityVote"),
        AVERAGE("average"),
        WEIGHTED_AVERAGE("weightedAverage"),
        MEDIAN("median"),
        WEIGHTED_MEDIAN("weightedMedian"),
        MAX("max"),
        SUM("sum"),
        WEIGHTED_SUM("weightedSum"),
        SELECT_FIRST("selectFirst"),
        SELECT_ALL("selectAll"),
        MODEL_CHAIN("modelChain");

        private final String value;

        private MultipleModelMethod(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static MultipleModelMethod fromValue(String v) {
            for (MultipleModelMethod c : MultipleModelMethod.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    @Added(value=Version.PMML_4_4)
    public static enum MissingPredictionTreatment implements StringValue<MissingPredictionTreatment>
    {
        RETURN_MISSING("returnMissing"),
        SKIP_SEGMENT("skipSegment"),
        CONTINUE("continue");

        private final String value;

        private MissingPredictionTreatment(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static MissingPredictionTreatment fromValue(String v) {
            for (MissingPredictionTreatment c : MissingPredictionTreatment.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

