/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder;

import java.util.HashMap;
import org.drools.compiler.lang.descr.ProcessDescr;
import org.jbpm.process.builder.ProcessBuildContext;
import org.jbpm.process.builder.ProcessNodeBuilder;
import org.jbpm.process.core.impl.DataTransformerRegistry;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.core.node.Transformation;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.process.DataTransformer;

public class EventNodeBuilder
implements ProcessNodeBuilder {
    @Override
    public void build(Process process, ProcessDescr processDescr, ProcessBuildContext context, Node node) {
        Transformation transformation = (Transformation)node.getMetaData().get("Transformation");
        if (transformation != null) {
            WorkflowProcess wfProcess = (WorkflowProcess)process;
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("imports", wfProcess.getImports());
            parameters.put("classloader", context.getConfiguration().getClassLoader());
            DataTransformer transformer = DataTransformerRegistry.get().find(transformation.getLanguage());
            transformation.setCompiledExpression(transformer.compile(transformation.getExpression(), parameters));
        }
        if (node instanceof BoundaryEventNode) {
            BoundaryEventNode boundaryEventNode = (BoundaryEventNode)node;
            boundaryEventNode.getOutAssociations().stream().filter(e -> e.getTransformation() != null).map(e -> e.getTransformation()).forEach(dataAssociationTransformation -> {
                WorkflowProcess wfProcess = (WorkflowProcess)process;
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("imports", wfProcess.getImports());
                parameters.put("classloader", context.getConfiguration().getClassLoader());
                DataTransformer transformer = DataTransformerRegistry.get().find(dataAssociationTransformation.getLanguage());
                dataAssociationTransformation.setCompiledExpression(transformer.compile(dataAssociationTransformation.getExpression(), parameters));
            });
        }
    }
}

