/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.timer.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.core.time.InternalSchedulerService;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.SelfRemovalJobContext;
import org.drools.core.time.TimerService;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.TimerJobInstance;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.JobNameHelper;
import org.jbpm.process.core.timer.NamedJobContext;
import org.jbpm.process.core.timer.SchedulerServiceInterceptor;
import org.jbpm.process.core.timer.impl.DelegateSchedulerServiceInterceptor;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.process.instance.timer.TimerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolSchedulerService
implements GlobalSchedulerService {
    private static final Logger logger = LoggerFactory.getLogger(ThreadPoolSchedulerService.class);
    private static final Integer FAILED_JOB_RETRIES = Integer.parseInt(System.getProperty("org.jbpm.timer.thread.retries", "5"));
    private static final Integer FAILED_JOB_DELAY = Integer.parseInt(System.getProperty("org.jbpm.timer.thread.delay", "1000"));
    private AtomicLong idCounter = new AtomicLong();
    private ScheduledThreadPoolExecutor scheduler;
    private TimerService globalTimerService;
    private SchedulerServiceInterceptor interceptor = new DelegateSchedulerServiceInterceptor(this);
    private int poolSize;
    private ConcurrentHashMap<String, JobHandle> activeTimer = new ConcurrentHashMap();

    public ThreadPoolSchedulerService(int poolSize) {
        this.poolSize = poolSize;
    }

    @Override
    public void initScheduler(TimerService globalTimerService) {
        this.globalTimerService = globalTimerService;
        this.scheduler = new ScheduledThreadPoolExecutor(this.poolSize);
    }

    @Override
    public void shutdown() {
        try {
            this.scheduler.shutdown();
            if (!this.scheduler.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.activeTimer.clear();
    }

    public JobHandle scheduleJob(Job job, JobContext ctx, Trigger trigger) {
        long id = this.idCounter.getAndIncrement();
        Date date = trigger.hasNextFireTime();
        if (date != null) {
            String jobname = JobNameHelper.getJobName(ctx, id);
            if (this.activeTimer.containsKey(jobname)) {
                return this.activeTimer.get(jobname);
            }
            GlobalJDKJobHandle jobHandle = new GlobalJDKJobHandle(id);
            TimerJobInstance jobInstance = this.globalTimerService.getTimerJobFactoryManager().createTimerJobInstance(job, ctx, trigger, (JobHandle)jobHandle, (InternalSchedulerService)this.globalTimerService);
            jobHandle.setTimerJobInstance(jobInstance);
            this.interceptor.internalSchedule(jobInstance);
            this.activeTimer.put(jobname, jobHandle);
            return jobHandle;
        }
        return null;
    }

    public boolean removeJob(JobHandle jobHandle) {
        if (jobHandle == null) {
            return false;
        }
        jobHandle.setCancel(true);
        JobContext jobContext = ((GlobalJDKJobHandle)jobHandle).getTimerJobInstance().getJobContext();
        try {
            TimerManager.ProcessJobContext processCtx = null;
            processCtx = jobContext instanceof SelfRemovalJobContext ? (TimerManager.ProcessJobContext)((SelfRemovalJobContext)jobContext).getJobContext() : (TimerManager.ProcessJobContext)jobContext;
            String jobname = JobNameHelper.getJobName(processCtx, jobContext.getJobHandle().getId());
            this.activeTimer.remove(jobname);
            this.globalTimerService.getTimerJobFactoryManager().removeTimerJobInstance(((GlobalJDKJobHandle)jobHandle).getTimerJobInstance());
        }
        catch (ClassCastException processCtx) {
            // empty catch block
        }
        boolean removed = this.scheduler.remove((Runnable)((Object)((GlobalJDKJobHandle)jobHandle).getFuture()));
        return removed;
    }

    public void internalSchedule(TimerJobInstance timerJobInstance) {
        if (this.scheduler.isShutdown()) {
            return;
        }
        Date date = timerJobInstance.getTrigger().hasNextFireTime();
        Callable item = (Callable)timerJobInstance;
        GlobalJDKJobHandle jobHandle = (GlobalJDKJobHandle)timerJobInstance.getJobHandle();
        long then = date.getTime();
        long now = System.currentTimeMillis();
        ScheduledFuture<Void> future = null;
        future = then >= now ? this.scheduler.schedule(new RetriggerCallable(this.scheduler, item), then - now, TimeUnit.MILLISECONDS) : this.scheduler.schedule(new RetriggerCallable(this.scheduler, item), 0L, TimeUnit.MILLISECONDS);
        jobHandle.setFuture(future);
        this.globalTimerService.getTimerJobFactoryManager().addTimerJobInstance(timerJobInstance);
    }

    @Override
    public JobHandle buildJobHandleForContext(NamedJobContext ctx) {
        return null;
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    @Override
    public void setInterceptor(SchedulerServiceInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    @Override
    public boolean retryEnabled() {
        return false;
    }

    @Override
    public boolean isValid(GlobalTimerService.GlobalJobHandle jobHandle) {
        return true;
    }

    private static class RetriggerCallable
    implements Callable<Void> {
        private Callable<Void> delegate;
        private ScheduledThreadPoolExecutor scheduler;
        private int retries = 0;

        RetriggerCallable(ScheduledThreadPoolExecutor scheduler, Callable<Void> delegate) {
            this.scheduler = scheduler;
            this.delegate = delegate;
        }

        @Override
        public Void call() throws Exception {
            try {
                this.delegate.call();
                return null;
            }
            catch (Exception e) {
                GlobalJDKJobHandle jobHandle = (GlobalJDKJobHandle)((TimerJobInstance)this.delegate).getJobHandle();
                if (this.retries < FAILED_JOB_RETRIES) {
                    ScheduledFuture<Void> future = this.scheduler.schedule(this, (long)FAILED_JOB_DELAY.intValue(), TimeUnit.MILLISECONDS);
                    jobHandle.setFuture(future);
                    ++this.retries;
                } else {
                    logger.error("Timer execution failed {} times in a roll, unscheduling ({})", (Object)FAILED_JOB_RETRIES, (Object)jobHandle);
                }
                throw e;
            }
        }
    }

    public static class GlobalJDKJobHandle
    extends GlobalTimerService.GlobalJobHandle
    implements Serializable {
        private static final long serialVersionUID = 510L;
        private transient ScheduledFuture<Void> future;

        public GlobalJDKJobHandle(long id) {
            super(id);
        }

        public ScheduledFuture<Void> getFuture() {
            return this.future;
        }

        public void setFuture(ScheduledFuture<Void> future) {
            this.future = future;
        }
    }
}

