/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.visitor.GenericVisitor;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.mvel.parser.MvelParser;
import org.drools.mvel.parser.ast.expr.ModifyStatement;
import org.drools.mvel.parser.ast.expr.WithStatement;
import org.drools.mvelcompiler.CompiledBlockResult;
import org.drools.mvelcompiler.MvelCompilerException;
import org.drools.mvelcompiler.PreprocessPhase;
import org.drools.mvelcompiler.StatementVisitor;
import org.drools.mvelcompiler.ast.TypedExpression;
import org.drools.mvelcompiler.context.MvelCompilerContext;

public class MvelCompiler {
    private final PreprocessPhase preprocessPhase = new PreprocessPhase();
    private final StatementVisitor statementVisitor;

    public MvelCompiler(MvelCompilerContext mvelCompilerContext) {
        this.statementVisitor = new StatementVisitor(mvelCompilerContext);
    }

    public CompiledBlockResult compileStatement(String mvelBlock) {
        BlockStmt mvelExpression = MvelParser.parseBlock((String)mvelBlock);
        this.preprocessPhase.removeEmptyStmt(mvelExpression);
        HashSet<String> allUsedBindings = new HashSet<String>();
        List modifyUsedBindings = mvelExpression.findAll(ModifyStatement.class).stream().flatMap(this::transformStatementWithPreprocessing).collect(Collectors.toList());
        List withUsedBindings = mvelExpression.findAll(WithStatement.class).stream().flatMap(this::transformStatementWithPreprocessing).collect(Collectors.toList());
        allUsedBindings.addAll(modifyUsedBindings);
        allUsedBindings.addAll(withUsedBindings);
        TypedExpression compiledRoot = (TypedExpression)mvelExpression.accept((GenericVisitor)this.statementVisitor, null);
        Node javaRoot = compiledRoot.toJavaExpression();
        if (!(javaRoot instanceof BlockStmt)) {
            throw new MvelCompilerException("With a BlockStmt as a input I was expecting a BlockStmt output");
        }
        BlockStmt compiledBlockStatement = (BlockStmt)javaRoot;
        return new CompiledBlockResult((List<Statement>)compiledBlockStatement.getStatements()).setUsedBindings(allUsedBindings);
    }

    private Stream<String> transformStatementWithPreprocessing(Statement s) {
        PreprocessPhase.PreprocessPhaseResult invoke = this.preprocessPhase.invoke(s);
        s.remove();
        return invoke.getUsedBindings().stream();
    }
}

