/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.ast.factories;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dmg.pmml.SimpleSetPredicate;
import org.drools.core.util.StringUtils;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.factories.KiePMMLAbstractPredicateASTFactory;
import org.kie.pmml.models.drools.ast.factories.KiePMMLSimpleSetPredicateWithAccumulationASTFactory;
import org.kie.pmml.models.drools.ast.factories.KiePMMLSimpleSetPredicateWithResultASTFactory;
import org.kie.pmml.models.drools.ast.factories.PredicateASTFactoryData;
import org.kie.pmml.models.drools.tuples.KiePMMLReasonCodeAndValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLSimpleSetPredicateASTFactory
extends KiePMMLAbstractPredicateASTFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLSimpleSetPredicateASTFactory.class.getName());

    private KiePMMLSimpleSetPredicateASTFactory(PredicateASTFactoryData predicateASTFactoryData) {
        super(predicateASTFactoryData);
    }

    public static KiePMMLSimpleSetPredicateASTFactory factory(PredicateASTFactoryData predicateASTFactoryData) {
        return new KiePMMLSimpleSetPredicateASTFactory(predicateASTFactoryData);
    }

    public void declareRuleFromSimpleSetPredicate(Number toAccumulate, String statusToSet, KiePMMLReasonCodeAndValue reasonCodeAndValue, boolean isLastCharacteristic) {
        logger.trace("declareRuleFromSimpleSetPredicate {} {} {}", new Object[]{toAccumulate, statusToSet, isLastCharacteristic});
        KiePMMLDroolsRule.Builder builder = this.getBuilderForSimpleSetPredicate(statusToSet).withAccumulation(toAccumulate);
        if (reasonCodeAndValue != null) {
            builder = builder.withReasonCodeAndValue(reasonCodeAndValue);
        }
        KiePMMLSimpleSetPredicateWithAccumulationASTFactory.declareRuleFromSimpleSetPredicate(builder, this.predicateASTFactoryData.getRules(), isLastCharacteristic);
    }

    public void declareRuleFromSimpleSetPredicate(Object result, boolean isFinalLeaf) {
        logger.trace("declareRuleFromSimpleSetPredicate {} {}", result, (Object)isFinalLeaf);
        String statusToSet = isFinalLeaf ? "DONE" : this.predicateASTFactoryData.getCurrentRule();
        KiePMMLDroolsRule.Builder builder = this.getBuilderForSimpleSetPredicate(statusToSet);
        KiePMMLSimpleSetPredicateWithResultASTFactory.declareRuleFromSimpleSetPredicate(builder, this.predicateASTFactoryData.getRules(), result, isFinalLeaf);
    }

    private KiePMMLDroolsRule.Builder getBuilderForSimpleSetPredicate(String statusToSet) {
        logger.trace("declareRuleFromSimpleSetPredicate {}", (Object)statusToSet);
        String statusConstraint = StringUtils.isEmpty((CharSequence)this.predicateASTFactoryData.getParentPath()) ? "status == null" : String.format("status == \"%s\"", this.predicateASTFactoryData.getParentPath());
        SimpleSetPredicate simpleSetPredicate = (SimpleSetPredicate)this.predicateASTFactoryData.getPredicate();
        String key = this.predicateASTFactoryData.getFieldTypeMap().get(simpleSetPredicate.getField().getValue()).getGeneratedType();
        String stringValue = (String)simpleSetPredicate.getArray().getValue();
        String[] valuesArray = stringValue.split(" ");
        List value = Arrays.stream(valuesArray).map(rawValue -> {
            String originalType;
            switch (originalType = this.predicateASTFactoryData.getFieldTypeMap().get(simpleSetPredicate.getField().getValue()).getOriginalType()) {
                case "string": {
                    return "\"" + rawValue + "\"";
                }
                case "double": {
                    return Double.valueOf(rawValue).toString();
                }
            }
            return rawValue;
        }).collect(Collectors.toList());
        Map<String, List<Object>> constraints = Collections.singletonMap(key, value);
        KiePMMLDroolsRule.Builder toReturn = KiePMMLDroolsRule.builder(this.predicateASTFactoryData.getCurrentRule(), statusToSet, this.predicateASTFactoryData.getOutputFields()).withStatusConstraint(statusConstraint);
        toReturn = SimpleSetPredicate.BooleanOperator.IS_IN.equals((Object)simpleSetPredicate.getBooleanOperator()) ? toReturn.withInConstraints(constraints) : toReturn.withNotInConstraints(constraints);
        return toReturn;
    }
}

