/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.namespace;

import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.osgi.service.blueprint.container.BlueprintContainer;

public class BlueprintContextHelper {
    private final BlueprintContainer blueprintContainer;
    private final Object blueprintContext;
    private final Method addObjectMethod;

    public BlueprintContextHelper(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
        try {
            Class<?> ctxClass = Class.forName("org.apache.aries.blueprint.di.ExecutionContext", true, blueprintContainer.getClass().getClassLoader());
            this.addObjectMethod = ctxClass.getMethod("addFullObject", String.class, Future.class);
            Class<?> holderClass = Class.forName("org.apache.aries.blueprint.di.ExecutionContext$Holder", true, blueprintContainer.getClass().getClassLoader());
            Method getCtxMethod = holderClass.getMethod("getContext", new Class[0]);
            this.blueprintContext = getCtxMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void registerBean(String name, Object bean) {
        try {
            this.addObjectMethod.invoke(this.blueprintContext, name, new CompletedFuture<Object>(bean));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class CompletedFuture<T>
    implements Future<T> {
        private final T result;

        public CompletedFuture(T result) {
            this.result = result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.result;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.result;
        }
    }
}

