/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Lag;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.TextIndex;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.utils.ConverterTypeUtil;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;

public class ExpressionFunctionUtils {
    static final String KIEPMMLNAMEVALUE_LIST_PARAM = "param1";
    static final String INNER_VARIABLE_NAME = "variable%s%s%s";
    static final LinkedHashMap<String, ClassOrInterfaceType> DEFAULT_PARAMETERTYPE_MAP = new LinkedHashMap();
    static final FieldAccessExpr CONVERTER_TYPE_UTIL_FIELD_ACCESSOR_EXPR;

    private ExpressionFunctionUtils() {
    }

    static MethodDeclaration getAggregatedExpressionMethodDeclaration(String methodName, Aggregate aggregate, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("Aggregate not managed, yet");
    }

    static MethodDeclaration getApplyExpressionMethodDeclaration(String methodName, Apply apply, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        String variableName = "applyVariable";
        BlockStmt body = ExpressionFunctionUtils.getApplyExpressionBlockStmt(variableName, apply, returnedType, parameterNameTypeMap);
        return ExpressionFunctionUtils.getExpressionMethodDeclaration(methodName, variableName, body, returnedType, parameterNameTypeMap);
    }

    static MethodDeclaration getConstantExpressionMethodDeclaration(String methodName, Constant constant, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        String variableName = "constantVariable";
        BlockStmt body = ExpressionFunctionUtils.getConstantExpressionBlockStmt(variableName, constant, returnedType, parameterNameTypeMap);
        return ExpressionFunctionUtils.getExpressionMethodDeclaration(methodName, variableName, body, returnedType, parameterNameTypeMap);
    }

    static MethodDeclaration getDiscretizeExpressionMethodDeclaration(String methodName, Discretize discretize, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("Discretize not managed, yet");
    }

    static MethodDeclaration getFieldRefExpressionMethodDeclaration(String methodName, FieldRef fieldRef, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        String variableName = "fieldRefVariable";
        BlockStmt body = parameterNameTypeMap.size() == 1 ? ExpressionFunctionUtils.getFieldRefExpressionFromCommonDataBlockStmt(variableName, fieldRef, returnedType, parameterNameTypeMap) : ExpressionFunctionUtils.getFieldRefExpressionFromDefineFunctionBlockStmt(variableName, fieldRef, returnedType, parameterNameTypeMap);
        return ExpressionFunctionUtils.getExpressionMethodDeclaration(methodName, variableName, body, returnedType, parameterNameTypeMap);
    }

    static MethodDeclaration getLagExpressionMethodDeclaration(String methodName, Lag lag, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("Lag not managed, yet");
    }

    static MethodDeclaration getMapValuesExpressionMethodDeclaration(String methodName, MapValues mapValues, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("MapValues not managed, yet");
    }

    static MethodDeclaration getNormContinuousExpressionMethodDeclaration(String methodName, NormContinuous normContinuous, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("NormContinuous not managed, yet");
    }

    static MethodDeclaration getNormDiscreteExpressionMethodDeclaration(String methodName, NormDiscrete normDiscrete, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("NormDiscrete not managed, yet");
    }

    static MethodDeclaration getTextIndexExpressionMethodDeclaration(String methodName, TextIndex textIndex, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("TextIndex not managed, yet");
    }

    static BlockStmt getExpressionBlockStmt(String variableName, Expression expression, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        if (expression instanceof Aggregate) {
            return ExpressionFunctionUtils.getAggregatedExpressionBlockStmt(variableName, (Aggregate)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof Apply) {
            return ExpressionFunctionUtils.getApplyExpressionBlockStmt(variableName, (Apply)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof Constant) {
            return ExpressionFunctionUtils.getConstantExpressionBlockStmt(variableName, (Constant)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof Discretize) {
            return ExpressionFunctionUtils.getDiscretizeExpressionBlockStmt(variableName, (Discretize)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof FieldRef) {
            if (parameterNameTypeMap.size() == 1) {
                return ExpressionFunctionUtils.getFieldRefExpressionFromCommonDataBlockStmt(variableName, (FieldRef)expression, returnedType, parameterNameTypeMap);
            }
            return ExpressionFunctionUtils.getFieldRefExpressionFromDefineFunctionBlockStmt(variableName, (FieldRef)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof Lag) {
            return ExpressionFunctionUtils.getLagExpressionBlockStmt(variableName, (Lag)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof MapValues) {
            return ExpressionFunctionUtils.getMapValuesExpressionBlockStmt(variableName, (MapValues)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof NormContinuous) {
            return ExpressionFunctionUtils.getNormContinuousExpressionBlockStmt(variableName, (NormContinuous)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof NormDiscrete) {
            return ExpressionFunctionUtils.getNormDiscreteExpressionBlockStmt(variableName, (NormDiscrete)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof TextIndex) {
            return ExpressionFunctionUtils.getTextIndexExpressionBlockStmt(variableName, (TextIndex)expression, returnedType, parameterNameTypeMap);
        }
        throw new IllegalArgumentException(String.format("Expression %s not managed", expression.getClass()));
    }

    static BlockStmt getAggregatedExpressionBlockStmt(String variableName, Aggregate aggregate, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("Aggregate not managed, yet");
    }

    static BlockStmt getApplyExpressionBlockStmt(String variableName, Apply apply, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        BlockStmt toReturn = new BlockStmt();
        ArrayList<String> innerVariables = new ArrayList<String>();
        innerVariables.add(KIEPMMLNAMEVALUE_LIST_PARAM);
        ClassOrInterfaceType objectReturnedType = StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName());
        if (apply.getExpressions() != null) {
            int counter = 1;
            for (Expression expression : apply.getExpressions()) {
                String innerVariable = String.format(INNER_VARIABLE_NAME, variableName, expression.getClass().getSimpleName(), counter);
                BlockStmt innerBlockStmt = ExpressionFunctionUtils.getExpressionBlockStmt(innerVariable, expression, objectReturnedType, parameterNameTypeMap);
                toReturn.getStatements().addAll(innerBlockStmt.getStatements());
                innerVariables.add(innerVariable);
                ++counter;
            }
        }
        MethodCallExpr functionMethodCall = new MethodCallExpr();
        functionMethodCall.setScope((com.github.javaparser.ast.expr.Expression)new ThisExpr());
        functionMethodCall.setName(apply.getFunction());
        NodeList functionCallArguments = NodeList.nodeList((Collection)innerVariables.stream().map(NameExpr::new).collect(Collectors.toList()));
        functionMethodCall.setArguments(functionCallArguments);
        VariableDeclarator variableDeclarator = new VariableDeclarator();
        variableDeclarator.setType((Type)returnedType);
        variableDeclarator.setName(variableName);
        variableDeclarator.setInitializer((com.github.javaparser.ast.expr.Expression)functionMethodCall);
        VariableDeclarationExpr variableDeclarationExpr = new VariableDeclarationExpr();
        variableDeclarationExpr.setVariables(NodeList.nodeList((Node[])new VariableDeclarator[]{variableDeclarator}));
        toReturn.addStatement((com.github.javaparser.ast.expr.Expression)variableDeclarationExpr);
        return toReturn;
    }

    static BlockStmt getConstantExpressionBlockStmt(String variableName, Constant constant, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        BlockStmt toReturn = new BlockStmt();
        VariableDeclarator variableDeclarator = new VariableDeclarator();
        variableDeclarator.setType((Type)returnedType);
        variableDeclarator.setName(variableName);
        Object constantValue = constant.getValue();
        if (constantValue instanceof String) {
            variableDeclarator.setInitializer((com.github.javaparser.ast.expr.Expression)new StringLiteralExpr((String)constantValue));
        } else {
            variableDeclarator.setInitializer((com.github.javaparser.ast.expr.Expression)new NameExpr(constantValue.toString()));
        }
        VariableDeclarationExpr variableDeclarationExpr = new VariableDeclarationExpr();
        variableDeclarationExpr.setVariables(NodeList.nodeList((Node[])new VariableDeclarator[]{variableDeclarator}));
        toReturn.addStatement((com.github.javaparser.ast.expr.Expression)variableDeclarationExpr);
        return toReturn;
    }

    static BlockStmt getDiscretizeExpressionBlockStmt(String variableName, Discretize discretize, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("Discretize not managed, yet");
    }

    static BlockStmt getFieldRefExpressionFromCommonDataBlockStmt(String variableName, FieldRef fieldRef, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        BlockStmt toReturn = new BlockStmt();
        String fieldNameToRef = fieldRef.getField().getValue();
        toReturn.addStatement((Statement)CommonCodegenUtils.getFilteredKiePMMLNameValueExpression(KIEPMMLNAMEVALUE_LIST_PARAM, fieldNameToRef, true));
        MethodReferenceExpr methodReferenceExpr = new MethodReferenceExpr();
        methodReferenceExpr.setScope((com.github.javaparser.ast.expr.Expression)new TypeExpr((Type)StaticJavaParser.parseClassOrInterfaceType((String)KiePMMLNameValue.class.getName())));
        methodReferenceExpr.setIdentifier("getValue");
        MethodCallExpr expressionScope = new MethodCallExpr("map", new com.github.javaparser.ast.expr.Expression[0]);
        expressionScope.setScope((com.github.javaparser.ast.expr.Expression)new NameExpr(CommonCodegenUtils.OPTIONAL_FILTERED_KIEPMMLNAMEVALUE_NAME));
        expressionScope.setArguments(NodeList.nodeList((Node[])new com.github.javaparser.ast.expr.Expression[]{methodReferenceExpr}));
        MethodCallExpr expression = new MethodCallExpr("orElse", new com.github.javaparser.ast.expr.Expression[0]);
        expression.setScope((com.github.javaparser.ast.expr.Expression)expressionScope);
        StringLiteralExpr orElseExpression = fieldRef.getMapMissingTo() != null ? new StringLiteralExpr(fieldRef.getMapMissingTo()) : new NullLiteralExpr();
        expression.setArguments(NodeList.nodeList((Node[])new com.github.javaparser.ast.expr.Expression[]{orElseExpression}));
        CastExpr initializer = new CastExpr();
        initializer.setType((Type)returnedType);
        initializer.setExpression((com.github.javaparser.ast.expr.Expression)expression);
        VariableDeclarator variableDeclarator = new VariableDeclarator();
        variableDeclarator.setType((Type)returnedType);
        variableDeclarator.setName(variableName);
        variableDeclarator.setInitializer((com.github.javaparser.ast.expr.Expression)initializer);
        VariableDeclarationExpr variableDeclarationExpr = new VariableDeclarationExpr();
        variableDeclarationExpr.setVariables(NodeList.nodeList((Node[])new VariableDeclarator[]{variableDeclarator}));
        toReturn.addStatement((com.github.javaparser.ast.expr.Expression)variableDeclarationExpr);
        return toReturn;
    }

    static BlockStmt getFieldRefExpressionFromDefineFunctionBlockStmt(String variableName, FieldRef fieldRef, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        BlockStmt toReturn = new BlockStmt();
        String fieldNameToRef = fieldRef.getField().getValue();
        NameExpr nameExpression = new NameExpr(fieldNameToRef);
        BinaryExpr condition = new BinaryExpr();
        condition.setLeft((com.github.javaparser.ast.expr.Expression)nameExpression);
        condition.setRight((com.github.javaparser.ast.expr.Expression)new NullLiteralExpr());
        condition.setOperator(BinaryExpr.Operator.NOT_EQUALS);
        CastExpr thenExpr = new CastExpr();
        thenExpr.setType((Type)returnedType);
        MethodCallExpr converterCallExpression = new MethodCallExpr();
        converterCallExpression.setName("convert");
        converterCallExpression.setScope((com.github.javaparser.ast.expr.Expression)CONVERTER_TYPE_UTIL_FIELD_ACCESSOR_EXPR);
        ClassExpr expectedClassExpression = new ClassExpr();
        expectedClassExpression.setType((Type)returnedType);
        converterCallExpression.setArguments(NodeList.nodeList((Node[])new com.github.javaparser.ast.expr.Expression[]{expectedClassExpression, nameExpression}));
        thenExpr.setExpression((com.github.javaparser.ast.expr.Expression)converterCallExpression);
        StringLiteralExpr elseExpression = fieldRef.getMapMissingTo() != null ? new StringLiteralExpr(fieldRef.getMapMissingTo()) : new NullLiteralExpr();
        CastExpr elseExpr = new CastExpr();
        elseExpr.setType((Type)returnedType);
        elseExpr.setExpression((com.github.javaparser.ast.expr.Expression)elseExpression);
        ConditionalExpr initializer = new ConditionalExpr();
        initializer.setCondition((com.github.javaparser.ast.expr.Expression)condition);
        initializer.setThenExpr((com.github.javaparser.ast.expr.Expression)thenExpr);
        initializer.setElseExpr((com.github.javaparser.ast.expr.Expression)elseExpr);
        VariableDeclarator variableDeclarator = new VariableDeclarator();
        variableDeclarator.setType((Type)returnedType);
        variableDeclarator.setName(variableName);
        variableDeclarator.setInitializer((com.github.javaparser.ast.expr.Expression)initializer);
        VariableDeclarationExpr variableDeclarationExpr = new VariableDeclarationExpr();
        variableDeclarationExpr.setVariables(NodeList.nodeList((Node[])new VariableDeclarator[]{variableDeclarator}));
        toReturn.addStatement((com.github.javaparser.ast.expr.Expression)variableDeclarationExpr);
        return toReturn;
    }

    static BlockStmt getLagExpressionBlockStmt(String variableName, Lag lag, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("Lag not managed, yet");
    }

    static BlockStmt getMapValuesExpressionBlockStmt(String variableName, MapValues mapValues, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("MapValues not managed, yet");
    }

    static BlockStmt getNormContinuousExpressionBlockStmt(String variableName, NormContinuous normContinuous, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("NormContinuous not managed, yet");
    }

    static BlockStmt getNormDiscreteExpressionBlockStmt(String variableName, NormDiscrete normDiscrete, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("NormDiscrete not managed, yet");
    }

    static BlockStmt getTextIndexExpressionBlockStmt(String variableName, TextIndex textIndex, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("TextIndex not managed, yet");
    }

    static MethodDeclaration getExpressionMethodDeclaration(String methodName, String variableName, BlockStmt body, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        ReturnStmt returnStmt = CommonCodegenUtils.getReturnStmt(variableName);
        body.addStatement((Statement)returnStmt);
        MethodDeclaration toReturn = CommonCodegenUtils.getMethodDeclaration(methodName, parameterNameTypeMap);
        toReturn.setType((Type)returnedType);
        toReturn.setBody(body);
        return toReturn;
    }

    static {
        DEFAULT_PARAMETERTYPE_MAP.put(KIEPMMLNAMEVALUE_LIST_PARAM, CommonCodegenUtils.getTypedClassOrInterfaceType(List.class.getName(), Collections.singletonList(KiePMMLNameValue.class.getName())));
        CONVERTER_TYPE_UTIL_FIELD_ACCESSOR_EXPR = new FieldAccessExpr();
        String converterTypeUtilFullName = ConverterTypeUtil.class.getName();
        CONVERTER_TYPE_UTIL_FIELD_ACCESSOR_EXPR.setName(converterTypeUtilFullName.substring(converterTypeUtilFullName.lastIndexOf(46) + 1));
        CONVERTER_TYPE_UTIL_FIELD_ACCESSOR_EXPR.setScope((com.github.javaparser.ast.expr.Expression)new NameExpr(converterTypeUtilFullName.substring(0, converterTypeUtilFullName.lastIndexOf(46))));
    }
}

