/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.core.utils;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostProcess {
    private static final Logger logger = LoggerFactory.getLogger(PostProcess.class);

    private PostProcess() {
    }

    public static void postProcess(PMML4Result toReturn, KiePMMLModel model, ProcessingDTO processingDTO) {
        PostProcess.executeTargets(toReturn, processingDTO);
        PostProcess.updateTargetValueType(model, toReturn);
        PostProcess.populateProcessingDTO(toReturn, model, processingDTO);
        PostProcess.populateOutputFields(toReturn, processingDTO, model);
    }

    static void populateProcessingDTO(PMML4Result pmml4Result, KiePMMLModel model, ProcessingDTO toPopulate) {
        pmml4Result.getResultVariables().forEach((key, value) -> toPopulate.addKiePMMLNameValue(new KiePMMLNameValue(key, value)));
        Map sortedByValue = model.getOutputFieldsMap().entrySet().stream().filter(entry -> entry.getValue() instanceof Double && (Double)entry.getValue() > 0.0).map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), (Double)entry.getValue())).sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        ArrayList orderedReasonCodes = new ArrayList(sortedByValue.keySet());
        toPopulate.addOrderedReasonCodes(orderedReasonCodes);
    }

    static void executeTargets(PMML4Result toModify, ProcessingDTO processingDTO) {
        logger.debug("executeTargets {} {}", (Object)toModify, (Object)processingDTO);
        if (!toModify.getResultCode().equals(ResultCode.OK.getName())) {
            return;
        }
        String targetFieldName = toModify.getResultObjectName();
        Map resultVariables = toModify.getResultVariables();
        processingDTO.getKiePMMLTargets().stream().filter(kiePMMLTarget -> kiePMMLTarget.getField() != null && kiePMMLTarget.getField().equals(targetFieldName)).findFirst().ifPresent(kiePMMLTarget -> {
            Object prediction = resultVariables.get(targetFieldName);
            logger.debug("Original prediction {}", prediction);
            Object modifiedPrediction = kiePMMLTarget.modifyPrediction(resultVariables.get(targetFieldName));
            logger.debug("Modified prediction {}", modifiedPrediction);
            resultVariables.put(targetFieldName, modifiedPrediction);
        });
    }

    static void updateTargetValueType(KiePMMLModel model, PMML4Result toUpdate) {
        DATA_TYPE dataType = model.getMiningFields().stream().filter(miningField -> model.getTargetField().equals(miningField.getName())).map(MiningField::getDataType).findFirst().orElseThrow(() -> new KiePMMLException("Failed to find DATA_TYPE for " + model.getTargetField()));
        Object prediction = toUpdate.getResultVariables().get(model.getTargetField());
        if (prediction != null) {
            Object convertedPrediction = dataType.getActualValue(prediction);
            toUpdate.getResultVariables().put(model.getTargetField(), convertedPrediction);
        }
    }

    static void populateOutputFields(PMML4Result toUpdate, ProcessingDTO processingDTO, KiePMMLModel model) {
        List<KiePMMLOutputField> reasonCodeOutputFields;
        List<KiePMMLOutputField> transformedOutputFields;
        logger.debug("populateOutputFields {} {}", (Object)toUpdate, (Object)processingDTO);
        Map<RESULT_FEATURE, List<KiePMMLOutputField>> outputFieldsByFeature = processingDTO.getOutputFields().stream().collect(Collectors.groupingBy(KiePMMLOutputField::getResultFeature));
        List<KiePMMLOutputField> predictedOutputFields = outputFieldsByFeature.get(RESULT_FEATURE.PREDICTED_VALUE);
        if (predictedOutputFields != null) {
            predictedOutputFields.forEach(outputField -> PostProcess.populatePredictedOutputField(outputField, toUpdate, processingDTO));
        }
        if ((transformedOutputFields = outputFieldsByFeature.get(RESULT_FEATURE.TRANSFORMED_VALUE)) != null) {
            transformedOutputFields.forEach(outputField -> PostProcess.populateTransformedOutputField(outputField, toUpdate, processingDTO));
        }
        if ((reasonCodeOutputFields = outputFieldsByFeature.get(RESULT_FEATURE.REASON_CODE)) != null) {
            reasonCodeOutputFields.forEach(outputField -> PostProcess.populateReasonCodeOutputField(outputField, toUpdate, processingDTO));
        }
    }

    static void populatePredictedOutputField(KiePMMLOutputField outputField, PMML4Result toUpdate, ProcessingDTO processingDTO) {
        logger.debug("populatePredictedOutputField {} {} {}", new Object[]{outputField, toUpdate, processingDTO});
        if (!RESULT_FEATURE.PREDICTED_VALUE.equals((Object)outputField.getResultFeature())) {
            throw new KiePMMLException("Unexpected " + outputField.getResultFeature());
        }
        Optional<Object> variableValue = Optional.ofNullable(outputField.evaluatePredictedValue(processingDTO));
        variableValue.ifPresent(objValue -> {
            String variableName = outputField.getName();
            toUpdate.addResultVariable(variableName, objValue);
            processingDTO.addKiePMMLNameValue(new KiePMMLNameValue(variableName, objValue));
        });
    }

    static void populateTransformedOutputField(KiePMMLOutputField outputField, PMML4Result toUpdate, ProcessingDTO processingDTO) {
        logger.debug("populateTransformedOutputField {} {} {}", new Object[]{outputField, toUpdate, processingDTO});
        if (!RESULT_FEATURE.TRANSFORMED_VALUE.equals((Object)outputField.getResultFeature())) {
            throw new KiePMMLException("Unexpected " + outputField.getResultFeature());
        }
        Optional<Object> variableValue = Optional.ofNullable(outputField.evaluateTransformedValue(processingDTO));
        variableValue.ifPresent(objValue -> {
            String variableName = outputField.getName();
            toUpdate.addResultVariable(variableName, objValue);
            processingDTO.addKiePMMLNameValue(new KiePMMLNameValue(variableName, objValue));
        });
    }

    static void populateReasonCodeOutputField(KiePMMLOutputField outputField, PMML4Result toUpdate, ProcessingDTO processingDTO) {
        logger.debug("populateReasonCodeOutputField {} {} {}", new Object[]{outputField, toUpdate, processingDTO});
        if (!RESULT_FEATURE.REASON_CODE.equals((Object)outputField.getResultFeature())) {
            throw new KiePMMLException("Unexpected " + outputField.getResultFeature());
        }
        Optional<Object> variableValue = Optional.ofNullable(outputField.evaluateReasonCodeValue(processingDTO));
        variableValue.ifPresent(objValue -> {
            toUpdate.addResultVariable(outputField.getName(), objValue);
            processingDTO.addKiePMMLNameValue(new KiePMMLNameValue(outputField.getName(), objValue));
        });
    }
}

