/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.pmml.ParameterInfo;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreProcess {
    private static final Logger logger = LoggerFactory.getLogger(PreProcess.class);

    private PreProcess() {
    }

    public static ProcessingDTO preProcess(KiePMMLModel model, PMMLContext context) {
        PreProcess.addMissingValuesReplacements(model, context);
        PMMLRequestData requestData = context.getRequestData();
        ProcessingDTO toReturn = PreProcess.createProcessingDTO(model, requestData.getMappedRequestParams());
        PreProcess.executeTransformations(toReturn, requestData);
        return toReturn;
    }

    static ProcessingDTO createProcessingDTO(KiePMMLModel model, Map<String, ParameterInfo> mappedRequestParams) {
        List<KiePMMLNameValue> kiePMMLNameValues = PreProcess.getKiePMMLNameValuesFromParameterInfos(mappedRequestParams.values());
        return new ProcessingDTO(model, kiePMMLNameValues, new ArrayList());
    }

    static void addMissingValuesReplacements(KiePMMLModel model, PMMLContext context) {
        logger.debug("addMissingValuesReplacements {} {}", (Object)model, (Object)context);
        PMMLRequestData requestData = context.getRequestData();
        Map mappedRequestParams = requestData.getMappedRequestParams();
        Map missingValueReplacementMap = model.getMissingValueReplacementMap();
        missingValueReplacementMap.forEach((fieldName, missingValueReplacement) -> {
            if (!mappedRequestParams.containsKey(fieldName)) {
                logger.debug("missingValueReplacement {} {}", fieldName, missingValueReplacement);
                requestData.addRequestParam(fieldName, missingValueReplacement);
                context.addMissingValueReplaced(fieldName, missingValueReplacement);
            }
        });
    }

    static void executeTransformations(ProcessingDTO processingDTO, PMMLRequestData requestData) {
        logger.debug("executeTransformations {} {}", (Object)processingDTO, (Object)requestData);
        for (KiePMMLDerivedField derivedField : processingDTO.getDerivedFields()) {
            Object derivedValue = derivedField.evaluate(processingDTO);
            if (derivedValue == null) continue;
            requestData.addRequestParam(derivedField.getName(), derivedValue);
            processingDTO.addKiePMMLNameValue(new KiePMMLNameValue(derivedField.getName(), derivedValue));
        }
    }

    static List<KiePMMLNameValue> getKiePMMLNameValuesFromParameterInfos(Collection<ParameterInfo> parameterInfos) {
        return parameterInfos.stream().map(parameterInfo -> new KiePMMLNameValue(parameterInfo.getName(), parameterInfo.getValue())).collect(Collectors.toList());
    }
}

