/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc;

import bitronix.tm.resource.common.TransactionContextHelper;
import bitronix.tm.resource.jdbc.BaseProxyHandlerClass;
import bitronix.tm.resource.jdbc.JdbcCallableStatementHandle;
import bitronix.tm.resource.jdbc.JdbcPooledConnection;
import bitronix.tm.resource.jdbc.JdbcPreparedStatementHandle;
import bitronix.tm.resource.jdbc.JdbcStatementHandle;
import bitronix.tm.resource.jdbc.JdbcUncachedPreparedStatementHandle;
import bitronix.tm.utils.ClassLoaderUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcConnectionHandle
extends BaseProxyHandlerClass {
    private static final Logger log = LoggerFactory.getLogger(JdbcConnectionHandle.class);
    private final JdbcPooledConnection jdbcPooledConnection;
    private final Connection delegate;
    private volatile boolean closed = false;

    public JdbcConnectionHandle(JdbcPooledConnection jdbcPooledConnection, Connection connection) {
        this.jdbcPooledConnection = jdbcPooledConnection;
        this.delegate = connection;
    }

    public JdbcPooledConnection getPooledConnection() {
        return this.jdbcPooledConnection;
    }

    private Connection getDelegate() throws SQLException {
        if (this.closed) {
            throw new SQLException("connection is closed");
        }
        return this.delegate;
    }

    public Connection getConnection() {
        return this.delegate;
    }

    public String toString() {
        return "a JdbcConnectionHandle of " + this.jdbcPooledConnection + " on " + this.delegate;
    }

    private void enlistResource() throws SQLException {
        if (this.closed) {
            throw new SQLException("connection handle already closed");
        }
        if (this.jdbcPooledConnection.getPoolingDataSource().getAutomaticEnlistingEnabled()) {
            try {
                TransactionContextHelper.enlistInCurrentTransaction(this.jdbcPooledConnection);
            }
            catch (SystemException ex) {
                throw (SQLException)new SQLException("error enlisting " + this).initCause(ex);
            }
            catch (RollbackException ex) {
                throw (SQLException)new SQLException("error enlisting " + this).initCause(ex);
            }
        }
    }

    public void close() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("closing " + this);
        }
        if (this.closed) {
            return;
        }
        this.jdbcPooledConnection.release();
        this.closed = true;
    }

    public void commit() throws SQLException {
        if (this.closed) {
            throw new SQLException("connection handle already closed");
        }
        if (this.jdbcPooledConnection.isParticipatingInActiveGlobalTransaction()) {
            throw new SQLException("cannot commit a resource enlisted in a global transaction");
        }
        this.getDelegate().commit();
    }

    public void rollback() throws SQLException {
        if (this.closed) {
            throw new SQLException("connection handle already closed");
        }
        if (this.jdbcPooledConnection.isParticipatingInActiveGlobalTransaction()) {
            throw new SQLException("cannot rollback a resource enlisted in a global transaction");
        }
        this.getDelegate().rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection handle already closed");
        }
        if (this.jdbcPooledConnection.isParticipatingInActiveGlobalTransaction()) {
            throw new SQLException("cannot rollback a resource enlisted in a global transaction");
        }
        this.getDelegate().rollback(savepoint);
    }

    public Savepoint setSavepoint() throws SQLException {
        if (this.closed) {
            throw new SQLException("connection handle already closed");
        }
        if (this.jdbcPooledConnection.isParticipatingInActiveGlobalTransaction()) {
            throw new SQLException("cannot set a savepoint on a resource enlisted in a global transaction");
        }
        return this.getDelegate().setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection handle already closed");
        }
        if (this.jdbcPooledConnection.isParticipatingInActiveGlobalTransaction()) {
            throw new SQLException("cannot set a savepoint on a resource enlisted in a global transaction");
        }
        return this.getDelegate().setSavepoint(name);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection handle already closed");
        }
        if (this.jdbcPooledConnection.isParticipatingInActiveGlobalTransaction()) {
            throw new SQLException("cannot release a savepoint on a resource enlisted in a global transaction");
        }
        this.getDelegate().releaseSavepoint(savepoint);
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.closed) {
            throw new SQLException("connection handle already closed");
        }
        if (this.jdbcPooledConnection.isParticipatingInActiveGlobalTransaction()) {
            return false;
        }
        return this.getDelegate().getAutoCommit();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection handle already closed");
        }
        if (!this.jdbcPooledConnection.isParticipatingInActiveGlobalTransaction()) {
            this.getDelegate().setAutoCommit(autoCommit);
        } else if (autoCommit) {
            throw new SQLException("autocommit is not allowed on a resource enlisted in a global transaction");
        }
    }

    public boolean isClosed() throws SQLException {
        return this.closed || this.getDelegate().isClosed();
    }

    public Statement createStatement() throws SQLException {
        this.enlistResource();
        Statement statement = this.getDelegate().createStatement();
        this.jdbcPooledConnection.registerUncachedStatement(statement);
        JdbcStatementHandle statementHandle = new JdbcStatementHandle(statement, this.jdbcPooledConnection);
        return (Statement)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{Statement.class}, (InvocationHandler)statementHandle);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.enlistResource();
        Statement statement = this.getDelegate().createStatement(resultSetType, resultSetConcurrency);
        this.jdbcPooledConnection.registerUncachedStatement(statement);
        JdbcStatementHandle statementHandle = new JdbcStatementHandle(statement, this.jdbcPooledConnection);
        return (Statement)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{Statement.class}, (InvocationHandler)statementHandle);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.enlistResource();
        Statement statement = this.getDelegate().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        this.jdbcPooledConnection.registerUncachedStatement(statement);
        JdbcStatementHandle statementHandle = new JdbcStatementHandle(statement, this.jdbcPooledConnection);
        return (Statement)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{Statement.class}, (InvocationHandler)statementHandle);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.enlistResource();
        CallableStatement statement = this.getDelegate().prepareCall(sql);
        this.jdbcPooledConnection.registerUncachedStatement(statement);
        JdbcCallableStatementHandle statementHandle = new JdbcCallableStatementHandle(statement, this.jdbcPooledConnection);
        return (CallableStatement)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{CallableStatement.class}, (InvocationHandler)statementHandle);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.enlistResource();
        CallableStatement statement = this.getDelegate().prepareCall(sql, resultSetType, resultSetConcurrency);
        this.jdbcPooledConnection.registerUncachedStatement(statement);
        JdbcCallableStatementHandle statementHandle = new JdbcCallableStatementHandle(statement, this.jdbcPooledConnection);
        return (CallableStatement)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{CallableStatement.class}, (InvocationHandler)statementHandle);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.enlistResource();
        CallableStatement statement = this.getDelegate().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.jdbcPooledConnection.registerUncachedStatement(statement);
        JdbcCallableStatementHandle statementHandle = new JdbcCallableStatementHandle(statement, this.jdbcPooledConnection);
        return (CallableStatement)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{CallableStatement.class}, (InvocationHandler)statementHandle);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        boolean useStatementCache;
        this.enlistResource();
        boolean bl = useStatementCache = this.getPooledConnection().getPoolingDataSource().getPreparedStatementCacheSize() > 0;
        if (useStatementCache) {
            JdbcPreparedStatementHandle proposedStmt = new JdbcPreparedStatementHandle(sql);
            JdbcPreparedStatementHandle cachedStmt = this.getPooledConnection().getCachedStatement(proposedStmt);
            if (cachedStmt == null) {
                PreparedStatement stmt = this.getDelegate().prepareStatement(sql);
                proposedStmt.setDelegate(stmt);
                cachedStmt = this.getPooledConnection().putCachedStatement(proposedStmt);
            }
            cachedStmt.setPooledConnection(this.getPooledConnection());
            return (PreparedStatement)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)cachedStmt);
        }
        PreparedStatement stmt = this.getDelegate().prepareStatement(sql);
        this.jdbcPooledConnection.registerUncachedStatement(stmt);
        JdbcUncachedPreparedStatementHandle statementHandle = new JdbcUncachedPreparedStatementHandle(stmt, this.jdbcPooledConnection);
        return (PreparedStatement)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)statementHandle);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        boolean useStatementCache;
        this.enlistResource();
        boolean bl = useStatementCache = this.getPooledConnection().getPoolingDataSource().getPreparedStatementCacheSize() > 0;
        if (useStatementCache) {
            JdbcPreparedStatementHandle proposedStmt = new JdbcPreparedStatementHandle(sql, autoGeneratedKeys);
            JdbcPreparedStatementHandle cachedStmt = this.getPooledConnection().getCachedStatement(proposedStmt);
            if (cachedStmt == null) {
                PreparedStatement stmt = this.getDelegate().prepareStatement(sql, autoGeneratedKeys);
                proposedStmt.setDelegate(stmt);
                cachedStmt = this.getPooledConnection().putCachedStatement(proposedStmt);
            }
            cachedStmt.setPooledConnection(this.getPooledConnection());
            return (PreparedStatement)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)cachedStmt);
        }
        PreparedStatement stmt = this.getDelegate().prepareStatement(sql, autoGeneratedKeys);
        this.jdbcPooledConnection.registerUncachedStatement(stmt);
        JdbcUncachedPreparedStatementHandle statementHandle = new JdbcUncachedPreparedStatementHandle(stmt, this.jdbcPooledConnection);
        return (PreparedStatement)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)statementHandle);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        boolean useStatementCache;
        this.enlistResource();
        boolean bl = useStatementCache = this.getPooledConnection().getPoolingDataSource().getPreparedStatementCacheSize() > 0;
        if (useStatementCache) {
            JdbcPreparedStatementHandle proposedStmt = new JdbcPreparedStatementHandle(sql, resultSetType, resultSetConcurrency);
            JdbcPreparedStatementHandle cachedStmt = this.getPooledConnection().getCachedStatement(proposedStmt);
            if (cachedStmt == null) {
                PreparedStatement stmt = this.getDelegate().prepareStatement(sql, resultSetType, resultSetConcurrency);
                proposedStmt.setDelegate(stmt);
                cachedStmt = this.getPooledConnection().putCachedStatement(proposedStmt);
            }
            cachedStmt.setPooledConnection(this.getPooledConnection());
            return (PreparedStatement)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)cachedStmt);
        }
        PreparedStatement stmt = this.getDelegate().prepareStatement(sql, resultSetType, resultSetConcurrency);
        this.jdbcPooledConnection.registerUncachedStatement(stmt);
        JdbcUncachedPreparedStatementHandle statementHandle = new JdbcUncachedPreparedStatementHandle(stmt, this.jdbcPooledConnection);
        return (PreparedStatement)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)statementHandle);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        boolean useStatementCache;
        this.enlistResource();
        boolean bl = useStatementCache = this.getPooledConnection().getPoolingDataSource().getPreparedStatementCacheSize() > 0;
        if (useStatementCache) {
            JdbcPreparedStatementHandle proposedStmt = new JdbcPreparedStatementHandle(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            JdbcPreparedStatementHandle cachedStmt = this.getPooledConnection().getCachedStatement(proposedStmt);
            if (cachedStmt == null) {
                PreparedStatement stmt = this.getDelegate().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
                proposedStmt.setDelegate(stmt);
                cachedStmt = this.getPooledConnection().putCachedStatement(proposedStmt);
            }
            cachedStmt.setPooledConnection(this.getPooledConnection());
            return (PreparedStatement)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)cachedStmt);
        }
        PreparedStatement stmt = this.getDelegate().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.jdbcPooledConnection.registerUncachedStatement(stmt);
        JdbcUncachedPreparedStatementHandle statementHandle = new JdbcUncachedPreparedStatementHandle(stmt, this.jdbcPooledConnection);
        return (PreparedStatement)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)statementHandle);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        boolean useStatementCache;
        this.enlistResource();
        boolean bl = useStatementCache = this.getPooledConnection().getPoolingDataSource().getPreparedStatementCacheSize() > 0;
        if (useStatementCache) {
            JdbcPreparedStatementHandle proposedStmt = new JdbcPreparedStatementHandle(sql, columnIndexes);
            JdbcPreparedStatementHandle cachedStmt = this.getPooledConnection().getCachedStatement(proposedStmt);
            if (cachedStmt == null) {
                PreparedStatement stmt = this.getDelegate().prepareStatement(sql, columnIndexes);
                proposedStmt.setDelegate(stmt);
                cachedStmt = this.getPooledConnection().putCachedStatement(proposedStmt);
            }
            cachedStmt.setPooledConnection(this.getPooledConnection());
            return (PreparedStatement)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)cachedStmt);
        }
        PreparedStatement stmt = this.getDelegate().prepareStatement(sql, columnIndexes);
        this.jdbcPooledConnection.registerUncachedStatement(stmt);
        JdbcUncachedPreparedStatementHandle statementHandle = new JdbcUncachedPreparedStatementHandle(stmt, this.jdbcPooledConnection);
        return (PreparedStatement)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)statementHandle);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        boolean useStatementCache;
        this.enlistResource();
        boolean bl = useStatementCache = this.getPooledConnection().getPoolingDataSource().getPreparedStatementCacheSize() > 0;
        if (useStatementCache) {
            JdbcPreparedStatementHandle proposedStmt = new JdbcPreparedStatementHandle(sql, columnNames);
            JdbcPreparedStatementHandle cachedStmt = this.getPooledConnection().getCachedStatement(proposedStmt);
            if (cachedStmt == null) {
                PreparedStatement stmt = this.getDelegate().prepareStatement(sql, columnNames);
                proposedStmt.setDelegate(stmt);
                cachedStmt = this.getPooledConnection().putCachedStatement(proposedStmt);
            }
            cachedStmt.setPooledConnection(this.getPooledConnection());
            return (PreparedStatement)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)cachedStmt);
        }
        PreparedStatement stmt = this.getDelegate().prepareStatement(sql, columnNames);
        this.jdbcPooledConnection.registerUncachedStatement(stmt);
        JdbcUncachedPreparedStatementHandle statementHandle = new JdbcUncachedPreparedStatementHandle(stmt, this.jdbcPooledConnection);
        return (PreparedStatement)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)statementHandle);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.delegate.getClass());
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.delegate.getClass())) {
            return (T)this.delegate;
        }
        throw new SQLException(this.getClass().getName() + " is not a wrapper for " + iface);
    }

    @Override
    public Object getProxiedDelegate() throws Exception {
        return this.delegate;
    }
}

