/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.util;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.kie.server.api.model.taskassigning.TaskData;
import org.kie.server.api.model.taskassigning.TaskDataList;
import org.kie.server.api.model.taskassigning.TaskInputVariablesReadMode;
import org.kie.server.client.TaskAssigningRuntimeClient;

public class TaskDataReader {
    private TaskAssigningRuntimeClient runtimeClient;

    private TaskDataReader(TaskAssigningRuntimeClient runtimeClient) {
        this.runtimeClient = runtimeClient;
    }

    public static TaskDataReader from(TaskAssigningRuntimeClient runtimeClient) {
        return new TaskDataReader(runtimeClient);
    }

    public Result readTasks(long fromTaskId, List<String> status, LocalDateTime fromLastModificationDate, int pageSize, TaskInputVariablesReadMode taskInputVariablesReadMode) {
        ArrayList result = new ArrayList();
        boolean finished = false;
        TaskData lastItem = null;
        LocalDateTime queryTime = null;
        long taskId = fromTaskId;
        int nextPageSize = pageSize;
        while (!finished) {
            TaskDataList taskDataList = this.runtimeClient.findTasks(taskId, status, fromLastModificationDate, 0, nextPageSize, taskInputVariablesReadMode);
            ArrayList partialResult = new ArrayList(taskDataList.getItems());
            if (queryTime == null) {
                queryTime = taskDataList.getQueryTime();
            }
            if (partialResult.isEmpty()) {
                finished = true;
                continue;
            }
            if (lastItem == null || partialResult.size() > 1) {
                lastItem = (TaskData)partialResult.remove(partialResult.size() - 1);
                taskId = lastItem.getTaskId();
                nextPageSize = pageSize;
                result.addAll(partialResult);
                continue;
            }
            if (lastItem.getTaskId().equals(((TaskData)partialResult.get(0)).getTaskId())) {
                if (((TaskData)partialResult.get(0)).getPotentialOwners().isEmpty()) {
                    result.add(partialResult.get(0));
                    lastItem = null;
                    ++taskId;
                    nextPageSize = pageSize;
                    continue;
                }
                if (((TaskData)partialResult.get(0)).getPotentialOwners().size() < nextPageSize) {
                    result.add(partialResult.get(0));
                    finished = true;
                    continue;
                }
                nextPageSize *= 2;
                continue;
            }
            lastItem = (TaskData)partialResult.get(0);
            taskId = lastItem.getTaskId();
            nextPageSize = pageSize;
        }
        return new Result(queryTime, result);
    }

    public Result readTasks(long fromTaskId, List<String> status, LocalDateTime fromLastModificationDate, int pageSize) {
        return this.readTasks(fromTaskId, status, fromLastModificationDate, pageSize, TaskInputVariablesReadMode.DONT_READ);
    }

    public static class Result {
        private LocalDateTime queryTime;
        private List<TaskData> tasks;

        private Result(LocalDateTime queryTime, List<TaskData> tasks) {
            this.queryTime = queryTime;
            this.tasks = tasks;
        }

        public LocalDateTime getQueryTime() {
            return this.queryTime;
        }

        public List<TaskData> getTasks() {
            return this.tasks;
        }
    }
}

