/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionManagerHelper;
import org.drools.persistence.api.Transformable;
import org.drools.persistence.jpa.JpaPersistenceContext;
import org.jbpm.persistence.api.PersistentCorrelationKey;
import org.jbpm.persistence.api.PersistentProcessInstance;
import org.jbpm.persistence.api.ProcessPersistenceContext;
import org.jbpm.persistence.correlation.CorrelationKeyInfo;
import org.jbpm.persistence.processinstance.ProcessInstanceInfo;
import org.kie.internal.process.CorrelationKey;

public class JpaProcessPersistenceContext
extends JpaPersistenceContext
implements ProcessPersistenceContext {
    public JpaProcessPersistenceContext(EntityManager em, TransactionManager txm) {
        super(em, txm);
    }

    public JpaProcessPersistenceContext(EntityManager em, boolean useJTA, boolean locking, String lockingMode, TransactionManager txm) {
        super(em, useJTA, locking, lockingMode, txm);
    }

    public PersistentProcessInstance persist(PersistentProcessInstance processInstanceInfo) {
        EntityManager em = this.getEntityManager();
        em.persist((Object)processInstanceInfo);
        TransactionManagerHelper.addToUpdatableSet((TransactionManager)this.txm, (Transformable)processInstanceInfo);
        if (this.pessimisticLocking) {
            em.flush();
            return (PersistentProcessInstance)em.find(ProcessInstanceInfo.class, (Object)processInstanceInfo.getId(), this.lockMode);
        }
        return processInstanceInfo;
    }

    public PersistentProcessInstance findProcessInstanceInfo(Long processId) {
        EntityManager em = this.getEntityManager();
        if (this.pessimisticLocking) {
            return (PersistentProcessInstance)em.find(ProcessInstanceInfo.class, (Object)processId, this.lockMode);
        }
        return (PersistentProcessInstance)em.find(ProcessInstanceInfo.class, (Object)processId);
    }

    public void remove(PersistentProcessInstance processInstanceInfo) {
        this.getEntityManager().remove((Object)processInstanceInfo);
        TransactionManagerHelper.removeFromUpdatableSet((TransactionManager)this.txm, (Transformable)processInstanceInfo);
        List correlations = this.getEntityManager().createNamedQuery("GetCorrelationKeysByProcessInstanceId").setParameter("pId", (Object)processInstanceInfo.getId()).getResultList();
        if (correlations != null) {
            for (CorrelationKeyInfo key : correlations) {
                this.getEntityManager().remove((Object)key);
            }
        }
    }

    public List<Long> getProcessInstancesWaitingForEvent(String type) {
        EntityManager entityManager = this.getEntityManager();
        if (entityManager != null) {
            Query processInstancesForEvent = this.getEntityManager().createNamedQuery("ProcessInstancesWaitingForEvent");
            processInstancesForEvent.setParameter("type", (Object)type);
            return processInstancesForEvent.getResultList();
        }
        return new ArrayList<Long>();
    }

    public PersistentCorrelationKey persist(PersistentCorrelationKey correlationKeyInfo) {
        try {
            EntityManager em = this.getEntityManager();
            em.persist((Object)correlationKeyInfo);
            em.flush();
            if (this.pessimisticLocking) {
                return (PersistentCorrelationKey)em.find(CorrelationKeyInfo.class, (Object)correlationKeyInfo.getId(), this.lockMode);
            }
            return correlationKeyInfo;
        }
        catch (PersistenceException e) {
            throw new RuntimeException(correlationKeyInfo + " already exists", e);
        }
    }

    public Long getProcessInstanceByCorrelationKey(CorrelationKey correlationKey) {
        Query processInstancesForEvent = this.getEntityManager().createNamedQuery("GetProcessInstanceIdByCorrelation");
        processInstancesForEvent.setParameter("ckey", (Object)correlationKey.toExternalForm());
        try {
            return (Long)processInstancesForEvent.getSingleResult();
        }
        catch (NonUniqueResultException e) {
            return null;
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

