/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.correlation;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.jbpm.persistence.correlation.CorrelationKeyInfo;
import org.kie.internal.process.CorrelationProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="CorrelationPropertyInfo", indexes={@Index(name="IDX_CorrPropInfo_Id", columnList="correlationKey_keyId")})
@SequenceGenerator(name="correlationPropertyInfoIdSeq", sequenceName="CORRELATION_PROP_ID_SEQ")
public class CorrelationPropertyInfo
implements CorrelationProperty<String>,
Serializable {
    private static final long serialVersionUID = -4469224502447675428L;
    private static final Logger logger = LoggerFactory.getLogger(CorrelationPropertyInfo.class);
    @Transient
    private final int CORRELATION_KEY_LOG_LENGTH = Integer.parseInt(System.getProperty("org.jbpm.correlationkey.length", "255"));
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="correlationPropertyInfoIdSeq")
    @Column(name="propertyId")
    private long id;
    @Version
    @Column(name="OPTLOCK")
    private int version;
    @ManyToOne
    private CorrelationKeyInfo correlationKey;
    private String name;
    private String value;

    public CorrelationPropertyInfo() {
    }

    public CorrelationPropertyInfo(String name, String value) {
        this.name = name;
        if (value != null && value.length() > this.CORRELATION_KEY_LOG_LENGTH) {
            value = value.substring(0, this.CORRELATION_KEY_LOG_LENGTH);
            logger.warn("CorrelationKey content was trimmed as it was too long (more than {} characters)", (Object)this.CORRELATION_KEY_LOG_LENGTH);
        }
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return String.class.getName();
    }

    public String getValue() {
        return this.value;
    }

    public CorrelationKeyInfo getCorrelationKey() {
        return this.correlationKey;
    }

    public void setCorrelationKey(CorrelationKeyInfo correlationKey) {
        this.correlationKey = correlationKey;
    }

    public String toString() {
        return "CorrelationPropertyInfo [name=" + this.name + ", value=" + this.value + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.correlationKey == null ? 0 : (int)(this.correlationKey.getId() ^ this.correlationKey.getId() >>> 32));
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CorrelationPropertyInfo other = (CorrelationPropertyInfo)obj;
        if (this.correlationKey == null ? other.correlationKey != null : this.correlationKey.getId() != other.correlationKey.getId()) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return this.version == other.version;
    }
}

