/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.executor;

import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.exceptions.ExternalException;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.model.HasSourcesMap;
import org.kie.pmml.commons.model.KiePMMLFactoryModel;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.factories.KiePMMLFactoryFactory;
import org.kie.pmml.compiler.commons.implementations.KiePMMLModelRetriever;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.pmml.compiler.executor.PMMLCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLCompilerImpl
implements PMMLCompiler {
    private static final Logger logger = LoggerFactory.getLogger((String)PMMLCompilerImpl.class.getName());

    @Override
    public List<KiePMMLModel> getKiePMMLModels(String packageName, InputStream inputStream, String fileName, HasClassLoader hasClassloader) {
        logger.trace("getModels {} {} {}", new Object[]{packageName, inputStream, hasClassloader});
        try {
            PMML commonPMMLModel = KiePMMLUtil.load((InputStream)inputStream, (String)fileName);
            return this.getModels(packageName, commonPMMLModel, hasClassloader);
        }
        catch (KiePMMLInternalException e) {
            throw new KiePMMLException("KiePMMLInternalException", (Throwable)e);
        }
        catch (KiePMMLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException("ExternalException", (Throwable)e);
        }
    }

    @Override
    public List<KiePMMLModel> getKiePMMLModelsWithSources(String factoryClassName, String packageName, InputStream inputStream, String fileName, HasClassLoader hasClassloader) {
        logger.trace("getModels {} {}", (Object)inputStream, (Object)hasClassloader);
        try {
            PMML commonPMMLModel = KiePMMLUtil.load((InputStream)inputStream, (String)fileName);
            Map<String, PMML_MODEL> expectedClassModelTypeMap = commonPMMLModel.getModels().stream().collect(Collectors.toMap(model -> {
                String modelPackageName = KiePMMLModelUtils.getSanitizedPackageName((String)String.format("%s.%s", packageName, model.getModelName()));
                return modelPackageName + "." + KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName());
            }, model -> PMML_MODEL.byName((String)model.getClass().getSimpleName())));
            List<KiePMMLModel> toReturn = this.getModelsWithSources(packageName, commonPMMLModel, hasClassloader);
            HashSet generatedClasses = new HashSet();
            toReturn.forEach(kiePMMLModel -> {
                if (!(kiePMMLModel instanceof HasSourcesMap)) {
                    throw new KiePMMLException(String.format("Expecting %s at this phase", HasSourcesMap.class.getCanonicalName()));
                }
                generatedClasses.addAll(((HasSourcesMap)kiePMMLModel).getSourcesMap().keySet());
            });
            Set<String> expectedClasses = expectedClassModelTypeMap.keySet();
            if (!generatedClasses.containsAll(expectedClasses)) {
                expectedClasses.removeAll(generatedClasses);
                String missingClasses = String.join((CharSequence)", ", expectedClasses);
                throw new KiePMMLException("Expected generated class " + missingClasses + " not found");
            }
            Map factorySourceMap = KiePMMLFactoryFactory.getFactorySourceCode((String)factoryClassName, (String)packageName, expectedClassModelTypeMap);
            KiePMMLFactoryModel kiePMMLFactoryModel = new KiePMMLFactoryModel(factoryClassName, packageName, factorySourceMap);
            toReturn.add((KiePMMLModel)kiePMMLFactoryModel);
            return toReturn;
        }
        catch (KiePMMLInternalException e) {
            throw new KiePMMLException("KiePMMLInternalException", (Throwable)e);
        }
        catch (KiePMMLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException("ExternalException", (Throwable)e);
        }
    }

    private List<KiePMMLModel> getModels(String packageName, PMML pmml, HasClassLoader hasClassloader) {
        logger.trace("getModels {}", (Object)pmml);
        return pmml.getModels().stream().map(model -> {
            CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)packageName, (PMML)pmml, (Model)model, (HasClassLoader)hasClassloader);
            return KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModel((CompilationDTO)compilationDTO);
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private List<KiePMMLModel> getModelsWithSources(String packageName, PMML pmml, HasClassLoader hasClassloader) {
        logger.trace("getModels {}", (Object)pmml);
        return pmml.getModels().stream().map(model -> {
            CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)packageName, (PMML)pmml, (Model)model, (HasClassLoader)hasClassloader);
            return KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSources((CompilationDTO)compilationDTO);
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

