/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model;

import org.drools.model.functions.Function1;

public interface Index<A, V> {
    public IndexType getIndexType();

    public Class<V> getIndexedClass();

    public ConstraintType getConstraintType();

    public int getIndexId();

    public Function1<A, V> getLeftOperandExtractor();

    public Index<A, V> negate();

    public static enum ConstraintType {
        EQUAL,
        NOT_EQUAL,
        GREATER_THAN,
        GREATER_OR_EQUAL,
        LESS_THAN,
        LESS_OR_EQUAL,
        RANGE,
        FORALL_SELF_JOIN,
        UNKNOWN;


        public ConstraintType negate() {
            switch (this) {
                case FORALL_SELF_JOIN: 
                case EQUAL: {
                    return NOT_EQUAL;
                }
                case NOT_EQUAL: {
                    return EQUAL;
                }
                case GREATER_THAN: {
                    return LESS_OR_EQUAL;
                }
                case GREATER_OR_EQUAL: {
                    return LESS_THAN;
                }
                case LESS_OR_EQUAL: {
                    return GREATER_THAN;
                }
                case LESS_THAN: {
                    return GREATER_OR_EQUAL;
                }
            }
            return UNKNOWN;
        }

        public boolean canInverse() {
            switch (this) {
                case EQUAL: 
                case NOT_EQUAL: 
                case GREATER_THAN: 
                case GREATER_OR_EQUAL: 
                case LESS_OR_EQUAL: 
                case LESS_THAN: {
                    return true;
                }
            }
            return false;
        }

        public ConstraintType inverse() {
            switch (this) {
                case GREATER_THAN: {
                    return LESS_THAN;
                }
                case GREATER_OR_EQUAL: {
                    return LESS_OR_EQUAL;
                }
                case LESS_THAN: {
                    return GREATER_THAN;
                }
                case LESS_OR_EQUAL: {
                    return GREATER_OR_EQUAL;
                }
            }
            return this;
        }

        public boolean isComparison() {
            return this.isAscending() || this.isDescending();
        }

        public boolean isAscending() {
            return this == GREATER_THAN || this == GREATER_OR_EQUAL;
        }

        public boolean isDescending() {
            return this == LESS_THAN || this == LESS_OR_EQUAL;
        }
    }

    public static enum IndexType {
        ALPHA,
        BETA;

    }
}

