/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import java.util.ArrayList;
import java.util.List;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.drools.ide.common.client.modeldriven.brl.RuleMetadata;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionRetractFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.ide.common.client.modeldriven.dt.AttributeCol;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.DTCellValue;
import org.drools.ide.common.client.modeldriven.dt.DescriptionCol;
import org.drools.ide.common.client.modeldriven.dt.MetadataCol;
import org.drools.ide.common.client.modeldriven.dt.RowNumberCol;
import org.drools.ide.common.client.modeldriven.dt.TypeSafeGuidedDecisionTable;
import org.drools.ide.common.server.util.BRDRLPersistence;
import org.drools.ide.common.server.util.GuidedDTDRLPersistence;
import org.drools.ide.common.server.util.RepositoryUpgradeHelper;
import org.junit.Assert;
import org.junit.Test;

public class GuidedDTDRLPersistenceTest {
    @Test
    public void test2Rules() throws Exception {
        TypeSafeGuidedDecisionTable dt = new TypeSafeGuidedDecisionTable();
        dt.setTableName("michael");
        AttributeCol attr = new AttributeCol();
        attr.setAttribute("salience");
        attr.setDefaultValue("66");
        dt.getAttributeCols().add(attr);
        ConditionCol con = new ConditionCol();
        con.setBoundName("f1");
        con.setConstraintValueType(1);
        con.setFactField("age");
        con.setFactType("Driver");
        con.setHeader("Driver f1 age");
        con.setOperator("==");
        dt.getConditionCols().add(con);
        ConditionCol con2 = new ConditionCol();
        con2.setBoundName("f1");
        con2.setConstraintValueType(1);
        con2.setFactField("name");
        con2.setFactType("Driver");
        con2.setHeader("Driver f1 name");
        con2.setOperator("==");
        dt.getConditionCols().add(con2);
        ConditionCol con3 = new ConditionCol();
        con3.setBoundName("f1");
        con3.setConstraintValueType(3);
        con3.setFactField("rating");
        con3.setFactType("Driver");
        con3.setHeader("Driver rating");
        con3.setOperator("==");
        dt.getConditionCols().add(con3);
        ConditionCol con4 = new ConditionCol();
        con4.setBoundName("f2");
        con4.setConstraintValueType(5);
        con4.setFactType("Driver");
        con4.setHeader("Driver 2 pimp");
        con4.setFactField("(not needed)");
        dt.getConditionCols().add(con4);
        ActionInsertFactCol ins = new ActionInsertFactCol();
        ins.setBoundName("ins");
        ins.setFactType("Cheese");
        ins.setFactField("price");
        ins.setType("Numeric");
        dt.getActionCols().add(ins);
        ActionRetractFactCol ret = new ActionRetractFactCol();
        ret.setBoundName("f2");
        dt.getActionCols().add(ret);
        ActionSetFieldCol set = new ActionSetFieldCol();
        set.setBoundName("f1");
        set.setFactField("goo1");
        set.setType("String");
        dt.getActionCols().add(set);
        ActionSetFieldCol set2 = new ActionSetFieldCol();
        set2.setBoundName("f1");
        set2.setFactField("goo2");
        set2.setDefaultValue("whee");
        set2.setType("String");
        dt.getActionCols().add(set2);
        dt.setData(RepositoryUpgradeHelper.makeDataLists((String[][])new String[][]{{"1", "desc", "42", "33", "michael", "age * 0.2", "age > 7", "6.60", "true", "gooVal1", null}, {"2", "desc", "", "39", "bob", "age * 0.3", "age > 7", "6.60", "", "gooVal1", ""}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        Assert.assertTrue((drl.indexOf("from row number") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("rating == ( age * 0.2 )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("f2 : Driver( eval( age > 7 ))") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("rating == ( age * 0.3 )") > drl.indexOf("rating == ( age * 0.2 )") ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("f1.setGoo2( \"whee\" )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("salience 66") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAttribs() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        String[] row = new String[]{"1", "desc", "a", ""};
        ArrayList<Object> allColumns = new ArrayList<Object>();
        allColumns.add(new RowNumberCol());
        allColumns.add(new DescriptionCol());
        ArrayList<AttributeCol> attributeCols = new ArrayList<AttributeCol>();
        RuleModel rm = new RuleModel();
        RuleAttribute[] orig = rm.attributes;
        p.doAttribs(allColumns, attributeCols, RepositoryUpgradeHelper.makeDataRowList((String[])row), rm);
        Assert.assertSame((Object)orig, (Object)rm.attributes);
        AttributeCol col1 = new AttributeCol();
        col1.setAttribute("salience");
        AttributeCol col2 = new AttributeCol();
        col2.setAttribute("agenda-group");
        attributeCols.add(col1);
        attributeCols.add(col2);
        allColumns.addAll(attributeCols);
        p.doAttribs(allColumns, attributeCols, RepositoryUpgradeHelper.makeDataRowList((String[])row), rm);
        Assert.assertEquals((long)1L, (long)rm.attributes.length);
        Assert.assertEquals((Object)"salience", (Object)rm.attributes[0].attributeName);
        Assert.assertEquals((Object)"a", (Object)rm.attributes[0].value);
        row = new String[]{"1", "desc", "a", "b"};
        p.doAttribs(allColumns, attributeCols, RepositoryUpgradeHelper.makeDataRowList((String[])row), rm);
        Assert.assertEquals((long)2L, (long)rm.attributes.length);
        Assert.assertEquals((Object)"salience", (Object)rm.attributes[0].attributeName);
        Assert.assertEquals((Object)"a", (Object)rm.attributes[0].value);
        Assert.assertEquals((Object)"agenda-group", (Object)rm.attributes[1].attributeName);
        Assert.assertEquals((Object)"b", (Object)rm.attributes[1].value);
    }

    @Test
    public void testCellCSV() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Assert.assertEquals((Object)"(\"Michael\", \"Mark\", \"Peter\")", (Object)p.makeInList("Michael, Mark, Peter"));
        Assert.assertEquals((Object)"(\"Michael\")", (Object)p.makeInList("Michael"));
        Assert.assertEquals((Object)"(\"Michael\")", (Object)p.makeInList("\"Michael\""));
        Assert.assertEquals((Object)"(\"Michael\", \"Ma rk\", \"Peter\")", (Object)p.makeInList("Michael, \"Ma rk\", Peter"));
        Assert.assertEquals((Object)"(WEE WAAH)", (Object)p.makeInList("(WEE WAAH)"));
    }

    @Test
    public void testCellVal() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Assert.assertFalse((boolean)p.validCell(null));
        Assert.assertFalse((boolean)p.validCell(""));
        Assert.assertFalse((boolean)p.validCell("  "));
    }

    @Test
    public void testInOperator() {
        TypeSafeGuidedDecisionTable dt = new TypeSafeGuidedDecisionTable();
        dt.setTableName("michael");
        AttributeCol attr = new AttributeCol();
        attr.setAttribute("salience");
        attr.setDefaultValue("66");
        dt.getAttributeCols().add(attr);
        ConditionCol con = new ConditionCol();
        con.setBoundName("f1");
        con.setConstraintValueType(1);
        con.setFactField("age");
        con.setFactType("Driver");
        con.setHeader("Driver f1 age");
        con.setOperator("==");
        dt.getConditionCols().add(con);
        ConditionCol con2 = new ConditionCol();
        con2.setBoundName("f1");
        con2.setConstraintValueType(1);
        con2.setFactField("name");
        con2.setFactType("Driver");
        con2.setHeader("Driver f1 name");
        con2.setOperator("in");
        dt.getConditionCols().add(con2);
        ConditionCol con3 = new ConditionCol();
        con3.setBoundName("f1");
        con3.setConstraintValueType(3);
        con3.setFactField("rating");
        con3.setFactType("Driver");
        con3.setHeader("Driver rating");
        con3.setOperator("==");
        dt.getConditionCols().add(con3);
        ConditionCol con4 = new ConditionCol();
        con4.setBoundName("f2");
        con4.setConstraintValueType(5);
        con4.setFactType("Driver");
        con4.setHeader("Driver 2 pimp");
        con4.setFactField("(not needed)");
        dt.getConditionCols().add(con4);
        ActionInsertFactCol ins = new ActionInsertFactCol();
        ins.setBoundName("ins");
        ins.setFactType("Cheese");
        ins.setFactField("price");
        ins.setType("Numeric");
        dt.getActionCols().add(ins);
        ActionRetractFactCol ret = new ActionRetractFactCol();
        ret.setBoundName("f2");
        dt.getActionCols().add(ret);
        ActionSetFieldCol set = new ActionSetFieldCol();
        set.setBoundName("f1");
        set.setFactField("goo1");
        set.setType("String");
        dt.getActionCols().add(set);
        ActionSetFieldCol set2 = new ActionSetFieldCol();
        set2.setBoundName("f1");
        set2.setFactField("goo2");
        set2.setDefaultValue("whee");
        set2.setType("String");
        dt.getActionCols().add(set2);
        dt.setData(RepositoryUpgradeHelper.makeDataLists((String[][])new String[][]{{"1", "desc", "42", "33", "michael, manik", "age * 0.2", "age > 7", "6.60", "true", "gooVal1", null}, {"2", "desc", "", "39", "bob, frank", "age * 0.3", "age > 7", "6.60", "", "gooVal1", ""}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        Assert.assertTrue((drl.indexOf("name in (\"michael\",") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testInterpolate() {
        TypeSafeGuidedDecisionTable dt = new TypeSafeGuidedDecisionTable();
        dt.setTableName("michael");
        AttributeCol attr = new AttributeCol();
        attr.setAttribute("salience");
        attr.setDefaultValue("66");
        dt.getAttributeCols().add(attr);
        ConditionCol con = new ConditionCol();
        con.setBoundName("f1");
        con.setConstraintValueType(1);
        con.setFactField("age");
        con.setFactType("Driver");
        con.setHeader("Driver f1 age");
        con.setOperator("==");
        dt.getConditionCols().add(con);
        ConditionCol con2 = new ConditionCol();
        con2.setBoundName("f1");
        con2.setConstraintValueType(1);
        con2.setFactField("name");
        con2.setFactType("Driver");
        con2.setHeader("Driver f1 name");
        con2.setOperator("==");
        dt.getConditionCols().add(con2);
        ConditionCol con3 = new ConditionCol();
        con3.setBoundName("f1");
        con3.setConstraintValueType(3);
        con3.setFactField("rating");
        con3.setFactType("Driver");
        con3.setHeader("Driver rating");
        con3.setOperator("==");
        dt.getConditionCols().add(con3);
        ConditionCol con4 = new ConditionCol();
        con4.setBoundName("f2");
        con4.setConstraintValueType(5);
        con4.setFactType("Driver");
        con4.setHeader("Driver 2 pimp");
        con4.setFactField("this.hasSomething($param)");
        dt.getConditionCols().add(con4);
        ActionInsertFactCol ins = new ActionInsertFactCol();
        ins.setBoundName("ins");
        ins.setFactType("Cheese");
        ins.setFactField("price");
        ins.setType("Numeric");
        dt.getActionCols().add(ins);
        ActionRetractFactCol ret = new ActionRetractFactCol();
        ret.setBoundName("f2");
        dt.getActionCols().add(ret);
        ActionSetFieldCol set = new ActionSetFieldCol();
        set.setBoundName("f1");
        set.setFactField("goo1");
        set.setType("String");
        dt.getActionCols().add(set);
        ActionSetFieldCol set2 = new ActionSetFieldCol();
        set2.setBoundName("f1");
        set2.setFactField("goo2");
        set2.setDefaultValue("whee");
        set2.setType("String");
        dt.getActionCols().add(set2);
        dt.setData(RepositoryUpgradeHelper.makeDataLists((String[][])new String[][]{{"1", "desc", "42", "33", "michael", "age * 0.2", "BAM", "6.60", "true", "gooVal1", null}, {"2", "desc", "", "39", "bob", "age * 0.3", "BAM", "6.60", "", "gooVal1", ""}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        Assert.assertTrue((drl.indexOf("from row number") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("rating == ( age * 0.2 )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("f2 : Driver( eval( this.hasSomething(BAM) ))") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("rating == ( age * 0.3 )") > drl.indexOf("rating == ( age * 0.2 )") ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("f1.setGoo2( \"whee\" )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("salience 66") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLHS() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        String[] row = new String[]{"1", "desc", "a", "mike", "33 + 1", "age > 6", "stilton"};
        String[][] data = new String[][]{row};
        ArrayList<Object> allColumns = new ArrayList<Object>();
        allColumns.add(new RowNumberCol());
        allColumns.add(new DescriptionCol());
        allColumns.add(new MetadataCol());
        ArrayList<ConditionCol> cols = new ArrayList<ConditionCol>();
        ConditionCol col = new ConditionCol();
        col.setBoundName("p1");
        col.setFactType("Person");
        col.setFactField("name");
        col.setConstraintValueType(1);
        col.setOperator("==");
        cols.add(col);
        ConditionCol col2 = new ConditionCol();
        col2.setBoundName("p1");
        col2.setFactType("Person");
        col2.setFactField("age");
        col2.setConstraintValueType(3);
        col2.setOperator("<");
        cols.add(col2);
        ConditionCol col3 = new ConditionCol();
        col3.setBoundName("p1");
        col3.setFactType("Person");
        col3.setConstraintValueType(5);
        cols.add(col3);
        ConditionCol col4 = new ConditionCol();
        col4.setBoundName("c");
        col4.setFactType("Cheese");
        col4.setFactField("type");
        col4.setOperator("==");
        col4.setConstraintValueType(1);
        cols.add(col4);
        RuleModel rm = new RuleModel();
        allColumns.addAll(cols);
        p.doConditions(allColumns, cols, RepositoryUpgradeHelper.makeDataRowList((String[])row), RepositoryUpgradeHelper.makeDataLists((String[][])data), rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Cheese", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"c", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        FactPattern person = (FactPattern)rm.lhs[0];
        Assert.assertEquals((long)3L, (long)person.constraintList.constraints.length);
        SingleFieldConstraint cons = (SingleFieldConstraint)person.constraintList.constraints[0];
        Assert.assertEquals((long)1L, (long)cons.getConstraintValueType());
        Assert.assertEquals((Object)"name", (Object)cons.getFieldName());
        Assert.assertEquals((Object)"==", (Object)cons.getOperator());
        Assert.assertEquals((Object)"mike", (Object)cons.getValue());
        cons = (SingleFieldConstraint)person.constraintList.constraints[1];
        Assert.assertEquals((long)3L, (long)cons.getConstraintValueType());
        Assert.assertEquals((Object)"age", (Object)cons.getFieldName());
        Assert.assertEquals((Object)"<", (Object)cons.getOperator());
        Assert.assertEquals((Object)"33 + 1", (Object)cons.getValue());
        cons = (SingleFieldConstraint)person.constraintList.constraints[2];
        Assert.assertEquals((long)5L, (long)cons.getConstraintValueType());
        Assert.assertEquals((Object)"age > 6", (Object)cons.getValue());
        FactPattern cheese = (FactPattern)rm.lhs[1];
        Assert.assertEquals((long)1L, (long)cheese.constraintList.constraints.length);
        cons = (SingleFieldConstraint)cheese.constraintList.constraints[0];
        Assert.assertEquals((Object)"type", (Object)cons.getFieldName());
        Assert.assertEquals((Object)"==", (Object)cons.getOperator());
        Assert.assertEquals((Object)"stilton", (Object)cons.getValue());
        Assert.assertEquals((long)1L, (long)cons.getConstraintValueType());
    }

    @Test
    public void testLHSNotPattern() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        String[] row = new String[]{"1", "desc", "a", "mike", "33 + 1", "age > 6", "stilton"};
        String[][] data = new String[][]{row};
        ArrayList<Object> allColumns = new ArrayList<Object>();
        allColumns.add(new RowNumberCol());
        allColumns.add(new DescriptionCol());
        allColumns.add(new MetadataCol());
        ArrayList<ConditionCol> cols = new ArrayList<ConditionCol>();
        ConditionCol col = new ConditionCol();
        col.setBoundName("p1");
        col.setFactType("Person");
        col.setFactField("name");
        col.setConstraintValueType(1);
        col.setOperator("==");
        col.setNegated(true);
        cols.add(col);
        ConditionCol col2 = new ConditionCol();
        col2.setBoundName("p1");
        col2.setFactType("Person");
        col2.setFactField("age");
        col2.setConstraintValueType(3);
        col2.setOperator("<");
        col2.setNegated(true);
        cols.add(col2);
        ConditionCol col3 = new ConditionCol();
        col3.setBoundName("p1");
        col3.setFactType("Person");
        col3.setConstraintValueType(5);
        col3.setNegated(true);
        cols.add(col3);
        ConditionCol col4 = new ConditionCol();
        col4.setBoundName("c");
        col4.setFactType("Cheese");
        col4.setFactField("type");
        col4.setOperator("==");
        col4.setConstraintValueType(1);
        cols.add(col4);
        RuleModel rm = new RuleModel();
        allColumns.addAll(cols);
        p.doConditions(allColumns, cols, RepositoryUpgradeHelper.makeDataRowList((String[])row), RepositoryUpgradeHelper.makeDataLists((String[][])data), rm);
        String drl = BRDRLPersistence.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Cheese", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"c", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        FactPattern person = (FactPattern)rm.lhs[0];
        Assert.assertEquals((long)3L, (long)person.constraintList.constraints.length);
        SingleFieldConstraint cons = (SingleFieldConstraint)person.constraintList.constraints[0];
        Assert.assertEquals((long)1L, (long)cons.getConstraintValueType());
        Assert.assertEquals((Object)"name", (Object)cons.getFieldName());
        Assert.assertEquals((Object)"==", (Object)cons.getOperator());
        Assert.assertEquals((Object)"mike", (Object)cons.getValue());
        cons = (SingleFieldConstraint)person.constraintList.constraints[1];
        Assert.assertEquals((long)3L, (long)cons.getConstraintValueType());
        Assert.assertEquals((Object)"age", (Object)cons.getFieldName());
        Assert.assertEquals((Object)"<", (Object)cons.getOperator());
        Assert.assertEquals((Object)"33 + 1", (Object)cons.getValue());
        cons = (SingleFieldConstraint)person.constraintList.constraints[2];
        Assert.assertEquals((long)5L, (long)cons.getConstraintValueType());
        Assert.assertEquals((Object)"age > 6", (Object)cons.getValue());
        Assert.assertEquals((Object)person.isNegated(), (Object)true);
        Assert.assertTrue((drl.indexOf("not Person(") > 0 ? 1 : 0) != 0);
        FactPattern cheese = (FactPattern)rm.lhs[1];
        Assert.assertEquals((long)1L, (long)cheese.constraintList.constraints.length);
        cons = (SingleFieldConstraint)cheese.constraintList.constraints[0];
        Assert.assertEquals((Object)"type", (Object)cons.getFieldName());
        Assert.assertEquals((Object)"==", (Object)cons.getOperator());
        Assert.assertEquals((Object)"stilton", (Object)cons.getValue());
        Assert.assertEquals((long)1L, (long)cons.getConstraintValueType());
        Assert.assertEquals((Object)cheese.isNegated(), (Object)false);
        Assert.assertTrue((drl.indexOf("c : Cheese(") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLHSOtherwisePatternBoolean() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        String[][] row = new String[2][];
        String[][] data = new String[2][];
        row[0] = new String[]{"1", "desc1", "true", "false"};
        List rowDTModel0 = RepositoryUpgradeHelper.makeDataRowList((String[])row[0]);
        data[0] = row[0];
        row[1] = new String[]{"3", "desc3", null, null};
        List rowDTModel1 = RepositoryUpgradeHelper.makeDataRowList((String[])row[1]);
        ((DTCellValue)rowDTModel1.get(2)).setOtherwise(true);
        ((DTCellValue)rowDTModel1.get(3)).setOtherwise(true);
        data[1] = row[1];
        ArrayList<Object> allColumns = new ArrayList<Object>();
        allColumns.add(new RowNumberCol());
        allColumns.add(new DescriptionCol());
        ArrayList<ConditionCol> cols = new ArrayList<ConditionCol>();
        ConditionCol col = new ConditionCol();
        col.setBoundName("p1");
        col.setFactType("Person");
        col.setFactField("alive");
        col.setConstraintValueType(1);
        col.setFieldType("Boolean");
        col.setOperator("==");
        cols.add(col);
        ConditionCol col2 = new ConditionCol();
        col2.setBoundName("p2");
        col2.setFactType("Person");
        col2.setFactField("alive");
        col2.setConstraintValueType(1);
        col2.setFieldType("Boolean");
        col2.setOperator("!=");
        cols.add(col2);
        RuleModel rm = new RuleModel();
        allColumns.addAll(cols);
        p.doConditions(allColumns, cols, rowDTModel0, RepositoryUpgradeHelper.makeDataLists((String[][])data), rm);
        String drl0 = BRDRLPersistence.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl0.indexOf("p1 : Person( alive == true )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl0.indexOf("p2 : Person( alive != false )") > 0 ? 1 : 0) != 0);
        p.doConditions(allColumns, cols, rowDTModel1, RepositoryUpgradeHelper.makeDataLists((String[][])data), rm);
        String drl1 = BRDRLPersistence.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl1.indexOf("p1 : Person( alive not in ( true )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl1.indexOf("p2 : Person( alive in ( false )") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLHSOtherwisePatternDate() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        String[][] row = new String[3][];
        String[][] data = new String[3][];
        row[0] = new String[]{"1", "desc1", "01-Jan-1980", "20-Jun-1985"};
        List rowDTModel0 = RepositoryUpgradeHelper.makeDataRowList((String[])row[0]);
        data[0] = row[0];
        row[1] = new String[]{"2", "desc2", "01-Feb-1981", "21-Jun-1986"};
        List rowDTModel1 = RepositoryUpgradeHelper.makeDataRowList((String[])row[1]);
        data[1] = row[1];
        row[2] = new String[]{"3", "desc3", null, null};
        List rowDTModel2 = RepositoryUpgradeHelper.makeDataRowList((String[])row[2]);
        ((DTCellValue)rowDTModel2.get(2)).setOtherwise(true);
        ((DTCellValue)rowDTModel2.get(3)).setOtherwise(true);
        data[2] = row[2];
        ArrayList<Object> allColumns = new ArrayList<Object>();
        allColumns.add(new RowNumberCol());
        allColumns.add(new DescriptionCol());
        ArrayList<ConditionCol> cols = new ArrayList<ConditionCol>();
        ConditionCol col = new ConditionCol();
        col.setBoundName("p1");
        col.setFactType("Person");
        col.setFactField("dateOfBirth");
        col.setConstraintValueType(1);
        col.setFieldType("Date");
        col.setOperator("==");
        cols.add(col);
        ConditionCol col2 = new ConditionCol();
        col2.setBoundName("p2");
        col2.setFactType("Person");
        col2.setFactField("dateOfBirth");
        col2.setConstraintValueType(1);
        col2.setFieldType("Date");
        col2.setOperator("!=");
        cols.add(col2);
        RuleModel rm = new RuleModel();
        allColumns.addAll(cols);
        p.doConditions(allColumns, cols, rowDTModel0, RepositoryUpgradeHelper.makeDataLists((String[][])data), rm);
        String drl0 = BRDRLPersistence.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl0.indexOf("p1 : Person( dateOfBirth == \"01-Jan-1980\" )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl0.indexOf("p2 : Person( dateOfBirth != \"20-Jun-1985\" )") > 0 ? 1 : 0) != 0);
        p.doConditions(allColumns, cols, rowDTModel1, RepositoryUpgradeHelper.makeDataLists((String[][])data), rm);
        String drl1 = BRDRLPersistence.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl1.indexOf("p1 : Person( dateOfBirth == \"01-Feb-1981\" )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl1.indexOf("p2 : Person( dateOfBirth != \"21-Jun-1986\" )") > 0 ? 1 : 0) != 0);
        p.doConditions(allColumns, cols, rowDTModel2, RepositoryUpgradeHelper.makeDataLists((String[][])data), rm);
        String drl2 = BRDRLPersistence.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl2.indexOf("p1 : Person( dateOfBirth not in ( \"01-Jan-1980\", \"01-Feb-1981\" )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl2.indexOf("p2 : Person( dateOfBirth in ( \"20-Jun-1985\", \"21-Jun-1986\" )") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLHSOtherwisePatternNumeric() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        String[][] row = new String[3][];
        String[][] data = new String[3][];
        row[0] = new String[]{"1", "desc1", "1", "1"};
        List rowDTModel0 = RepositoryUpgradeHelper.makeDataRowList((String[])row[0]);
        data[0] = row[0];
        row[1] = new String[]{"2", "desc2", "2", "2"};
        List rowDTModel1 = RepositoryUpgradeHelper.makeDataRowList((String[])row[1]);
        data[1] = row[1];
        row[2] = new String[]{"3", "desc3", null, null};
        List rowDTModel2 = RepositoryUpgradeHelper.makeDataRowList((String[])row[2]);
        ((DTCellValue)rowDTModel2.get(2)).setOtherwise(true);
        ((DTCellValue)rowDTModel2.get(3)).setOtherwise(true);
        data[2] = row[2];
        ArrayList<Object> allColumns = new ArrayList<Object>();
        allColumns.add(new RowNumberCol());
        allColumns.add(new DescriptionCol());
        ArrayList<ConditionCol> cols = new ArrayList<ConditionCol>();
        ConditionCol col = new ConditionCol();
        col.setBoundName("p1");
        col.setFactType("Person");
        col.setFactField("age");
        col.setConstraintValueType(1);
        col.setFieldType("Numeric");
        col.setOperator("==");
        cols.add(col);
        ConditionCol col2 = new ConditionCol();
        col2.setBoundName("p2");
        col2.setFactType("Person");
        col2.setFactField("age");
        col2.setConstraintValueType(1);
        col2.setFieldType("Numeric");
        col2.setOperator("!=");
        cols.add(col2);
        RuleModel rm = new RuleModel();
        allColumns.addAll(cols);
        p.doConditions(allColumns, cols, rowDTModel0, RepositoryUpgradeHelper.makeDataLists((String[][])data), rm);
        String drl0 = BRDRLPersistence.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl0.indexOf("p1 : Person( age == 1 )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl0.indexOf("p2 : Person( age != 1 )") > 0 ? 1 : 0) != 0);
        p.doConditions(allColumns, cols, rowDTModel1, RepositoryUpgradeHelper.makeDataLists((String[][])data), rm);
        String drl1 = BRDRLPersistence.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl1.indexOf("p1 : Person( age == 2 )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl1.indexOf("p2 : Person( age != 2 )") > 0 ? 1 : 0) != 0);
        p.doConditions(allColumns, cols, rowDTModel2, RepositoryUpgradeHelper.makeDataLists((String[][])data), rm);
        String drl2 = BRDRLPersistence.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl2.indexOf("p1 : Person( age not in ( 1, 2 )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl2.indexOf("p2 : Person( age in ( 1, 2 )") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLHSOtherwisePatternString() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        String[][] row = new String[3][];
        String[][] data = new String[3][];
        row[0] = new String[]{"1", "desc1", "Michael1", "Michael1"};
        List rowDTModel0 = RepositoryUpgradeHelper.makeDataRowList((String[])row[0]);
        data[0] = row[0];
        row[1] = new String[]{"2", "desc2", "Michael2", "Michael2"};
        List rowDTModel1 = RepositoryUpgradeHelper.makeDataRowList((String[])row[1]);
        data[1] = row[1];
        row[2] = new String[]{"3", "desc3", null, null};
        List rowDTModel2 = RepositoryUpgradeHelper.makeDataRowList((String[])row[2]);
        ((DTCellValue)rowDTModel2.get(2)).setOtherwise(true);
        ((DTCellValue)rowDTModel2.get(3)).setOtherwise(true);
        data[2] = row[2];
        ArrayList<Object> allColumns = new ArrayList<Object>();
        allColumns.add(new RowNumberCol());
        allColumns.add(new DescriptionCol());
        ArrayList<ConditionCol> cols = new ArrayList<ConditionCol>();
        ConditionCol col = new ConditionCol();
        col.setBoundName("p1");
        col.setFactType("Person");
        col.setFactField("name");
        col.setConstraintValueType(1);
        col.setFieldType("String");
        col.setOperator("==");
        cols.add(col);
        ConditionCol col2 = new ConditionCol();
        col2.setBoundName("p2");
        col2.setFactType("Person");
        col2.setFactField("name");
        col2.setConstraintValueType(1);
        col2.setFieldType("String");
        col2.setOperator("!=");
        cols.add(col2);
        RuleModel rm = new RuleModel();
        allColumns.addAll(cols);
        p.doConditions(allColumns, cols, rowDTModel0, RepositoryUpgradeHelper.makeDataLists((String[][])data), rm);
        String drl0 = BRDRLPersistence.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl0.indexOf("p1 : Person( name == \"Michael1\" )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl0.indexOf("p2 : Person( name != \"Michael1\" )") > 0 ? 1 : 0) != 0);
        p.doConditions(allColumns, cols, rowDTModel1, RepositoryUpgradeHelper.makeDataLists((String[][])data), rm);
        String drl1 = BRDRLPersistence.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl1.indexOf("p1 : Person( name == \"Michael2\" )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl1.indexOf("p2 : Person( name != \"Michael2\" )") > 0 ? 1 : 0) != 0);
        p.doConditions(allColumns, cols, rowDTModel2, RepositoryUpgradeHelper.makeDataLists((String[][])data), rm);
        String drl2 = BRDRLPersistence.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl2.indexOf("p1 : Person( name not in ( \"Michael1\", \"Michael2\" )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl2.indexOf("p2 : Person( name in ( \"Michael1\", \"Michael2\" )") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMetaData() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        String[] row = new String[]{"1", "desc", "bar", ""};
        ArrayList<Object> allColumns = new ArrayList<Object>();
        allColumns.add(new RowNumberCol());
        allColumns.add(new DescriptionCol());
        ArrayList<MetadataCol> metadataCols = new ArrayList<MetadataCol>();
        RuleModel rm = new RuleModel();
        RuleMetadata[] orig = rm.metadataList;
        p.doMetadata(allColumns, metadataCols, RepositoryUpgradeHelper.makeDataRowList((String[])row), rm);
        Assert.assertSame((Object)orig, (Object)rm.metadataList);
        MetadataCol col1 = new MetadataCol();
        col1.setMetadata("foo");
        MetadataCol col2 = new MetadataCol();
        col2.setMetadata("foo2");
        metadataCols.add(col1);
        metadataCols.add(col2);
        allColumns.addAll(metadataCols);
        p.doMetadata(allColumns, metadataCols, RepositoryUpgradeHelper.makeDataRowList((String[])row), rm);
        Assert.assertEquals((long)1L, (long)rm.metadataList.length);
        Assert.assertEquals((Object)"foo", (Object)rm.metadataList[0].attributeName);
        Assert.assertEquals((Object)"bar", (Object)rm.metadataList[0].value);
        row = new String[]{"1", "desc", "bar1", "bar2"};
        p.doMetadata(allColumns, metadataCols, RepositoryUpgradeHelper.makeDataRowList((String[])row), rm);
        Assert.assertEquals((long)2L, (long)rm.metadataList.length);
        Assert.assertEquals((Object)"foo", (Object)rm.metadataList[0].attributeName);
        Assert.assertEquals((Object)"bar1", (Object)rm.metadataList[0].value);
        Assert.assertEquals((Object)"foo2", (Object)rm.metadataList[1].attributeName);
        Assert.assertEquals((Object)"bar2", (Object)rm.metadataList[1].value);
    }

    @Test
    public void testName() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Assert.assertEquals((Object)"Row 42 XXX", (Object)p.getName("XXX", (Number)42));
        Assert.assertEquals((Object)"Row 42 YYY", (Object)p.getName("YYY", (Number)42));
    }

    @Test
    public void testNoConstraints() {
        TypeSafeGuidedDecisionTable dt = new TypeSafeGuidedDecisionTable();
        ConditionCol c = new ConditionCol();
        c.setBoundName("x");
        c.setFactType("Context");
        c.setConstraintValueType(1);
        dt.getConditionCols().add(c);
        ActionSetFieldCol asf = new ActionSetFieldCol();
        asf.setBoundName("x");
        asf.setFactField("age");
        asf.setType("String");
        dt.getActionCols().add(asf);
        String[][] data = new String[][]{{"1", "desc", "y", "old"}};
        dt.setData(RepositoryUpgradeHelper.makeDataLists((String[][])data));
        String drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        Assert.assertTrue((drl.indexOf("Context( )") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("x.setAge") > drl.indexOf("Context( )") ? 1 : 0) != 0);
        Assert.assertFalse((drl.indexOf("update( x );") > -1 ? 1 : 0) != 0);
        dt.setData(RepositoryUpgradeHelper.makeDataLists((String[][])new String[][]{{"1", "desc", "", "old"}}));
        drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        Assert.assertEquals((long)-1L, (long)drl.indexOf("Context( )"));
    }

    @Test
    public void testNoOperator() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        String[] row = new String[]{"1", "desc", "a", "> 42", "33 + 1", "age > 6", "stilton"};
        String[][] data = new String[][]{row};
        ArrayList<Object> allColumns = new ArrayList<Object>();
        allColumns.add(new RowNumberCol());
        allColumns.add(new DescriptionCol());
        allColumns.add(new MetadataCol());
        ArrayList<ConditionCol> cols = new ArrayList<ConditionCol>();
        ConditionCol col2 = new ConditionCol();
        col2.setBoundName("p1");
        col2.setFactType("Person");
        col2.setFactField("age");
        col2.setConstraintValueType(1);
        col2.setOperator("");
        cols.add(col2);
        RuleModel rm = new RuleModel();
        allColumns.addAll(cols);
        p.doConditions(allColumns, cols, RepositoryUpgradeHelper.makeDataRowList((String[])row), RepositoryUpgradeHelper.makeDataLists((String[][])data), rm);
        String drl = BRDRLPersistence.getInstance().marshal(rm);
        Assert.assertTrue((drl.indexOf("age > \"42\"") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRHS() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        String[] row = new String[]{"1", "desc", "a", "a condition", "actionsetfield1", "actionsetfield2", "retract", "actioninsertfact1", "actioninsertfact2"};
        ArrayList<Object> allColumns = new ArrayList<Object>();
        allColumns.add(new RowNumberCol());
        allColumns.add(new DescriptionCol());
        allColumns.add(new MetadataCol());
        allColumns.add(new ConditionCol());
        ArrayList<Object> cols = new ArrayList<Object>();
        ActionSetFieldCol asf1 = new ActionSetFieldCol();
        asf1.setBoundName("a");
        asf1.setFactField("field1");
        asf1.setType("String");
        cols.add(asf1);
        ActionSetFieldCol asf2 = new ActionSetFieldCol();
        asf2.setBoundName("a");
        asf2.setFactField("field2");
        asf2.setUpdate(true);
        asf2.setType("Numeric");
        cols.add(asf2);
        ActionRetractFactCol ret = new ActionRetractFactCol();
        ret.setBoundName("ret");
        cols.add(ret);
        ActionInsertFactCol ins1 = new ActionInsertFactCol();
        ins1.setBoundName("ins");
        ins1.setFactType("Cheese");
        ins1.setFactField("price");
        ins1.setType("Numeric");
        cols.add(ins1);
        ActionInsertFactCol ins2 = new ActionInsertFactCol();
        ins2.setBoundName("ins");
        ins2.setFactType("Cheese");
        ins2.setFactField("type");
        ins2.setType("Numeric");
        cols.add(ins2);
        RuleModel rm = new RuleModel();
        allColumns.addAll(cols);
        p.doActions(allColumns, cols, RepositoryUpgradeHelper.makeDataRowList((String[])row), rm);
        Assert.assertEquals((long)3L, (long)rm.rhs.length);
        ActionSetField a1 = (ActionSetField)rm.rhs[0];
        Assert.assertEquals((Object)"a", (Object)a1.variable);
        Assert.assertEquals((long)2L, (long)a1.fieldValues.length);
        Assert.assertEquals((Object)"field1", (Object)a1.fieldValues[0].field);
        Assert.assertEquals((Object)"actionsetfield1", (Object)a1.fieldValues[0].value);
        Assert.assertEquals((Object)"String", (Object)a1.fieldValues[0].type);
        Assert.assertEquals((Object)"field2", (Object)a1.fieldValues[1].field);
        Assert.assertEquals((Object)"actionsetfield2", (Object)a1.fieldValues[1].value);
        Assert.assertEquals((Object)"Numeric", (Object)a1.fieldValues[1].type);
        ActionRetractFact a2 = (ActionRetractFact)rm.rhs[1];
        Assert.assertEquals((Object)"ret", (Object)a2.variableName);
        ActionInsertFact a3 = (ActionInsertFact)rm.rhs[2];
        Assert.assertEquals((Object)"Cheese", (Object)a3.factType);
        Assert.assertEquals((long)2L, (long)a3.fieldValues.length);
        Assert.assertEquals((Object)"price", (Object)a3.fieldValues[0].field);
        Assert.assertEquals((Object)"actioninsertfact1", (Object)a3.fieldValues[0].value);
        Assert.assertEquals((Object)"Numeric", (Object)a3.fieldValues[0].type);
        Assert.assertEquals((Object)"type", (Object)a3.fieldValues[1].field);
        Assert.assertEquals((Object)"actioninsertfact2", (Object)a3.fieldValues[1].value);
        Assert.assertEquals((Object)"Numeric", (Object)a3.fieldValues[1].type);
    }

    @Test
    public void testUpdateModify() {
        TypeSafeGuidedDecisionTable dt = new TypeSafeGuidedDecisionTable();
        ConditionCol c = new ConditionCol();
        c.setBoundName("x");
        c.setFactType("Context");
        c.setConstraintValueType(1);
        dt.getConditionCols().add(c);
        ActionSetFieldCol asf = new ActionSetFieldCol();
        asf.setBoundName("x");
        asf.setFactField("age");
        asf.setType("Numeric");
        asf.setUpdate(true);
        dt.getActionCols().add(asf);
        String[][] data = new String[][]{{"1", "desc", "y", "old"}};
        dt.setData(RepositoryUpgradeHelper.makeDataLists((String[][])data));
        String drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        System.err.println(drl);
        Assert.assertTrue((drl.indexOf("Context( )") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("x.setAge") > drl.indexOf("Context( )") ? 1 : 0) != 0);
        dt.setData(RepositoryUpgradeHelper.makeDataLists((String[][])new String[][]{{"1", "desc", "", "old"}}));
        drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        Assert.assertEquals((long)-1L, (long)drl.indexOf("Context( )"));
        Assert.assertTrue((drl.indexOf("update( x );") > -1 ? 1 : 0) != 0);
    }
}

