/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.broker.ui;

import java.awt.Color;
import java.text.NumberFormat;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.drools.examples.broker.model.Company;

public class CompanyPanel
extends JPanel {
    private static final int FIELD_COLUMN_SIZE = 8;
    private final Company model;
    private final JTextField currentField;
    private final JTextField previousField;
    private NumberFormat format = NumberFormat.getCurrencyInstance();

    public CompanyPanel(Company model) {
        this.model = model;
        GroupLayout formLayout = new GroupLayout(this);
        this.setLayout(formLayout);
        formLayout.setAutoCreateGaps(true);
        formLayout.setAutoCreateContainerGaps(true);
        JLabel companyNameField = new JLabel(model.getName());
        companyNameField.setFont(companyNameField.getFont().deriveFont((float)companyNameField.getFont().getSize() + 2.0f));
        JLabel currentLabel = new JLabel("Current: ");
        this.currentField = new JTextField(this.format.format(model.getCurrentPrice()), 8);
        this.currentField.setEditable(false);
        JLabel previousLabel = new JLabel("Previous:");
        this.previousField = new JTextField(this.format.format(model.getPreviousPrice()), 8);
        this.previousField.setEditable(false);
        formLayout.setHorizontalGroup(formLayout.createParallelGroup().addComponent(companyNameField).addGroup(formLayout.createSequentialGroup().addGap(10).addComponent(currentLabel).addGap(10).addComponent(this.currentField)).addGroup(formLayout.createSequentialGroup().addGap(10).addComponent(previousLabel).addGap(10).addComponent(this.previousField)));
        formLayout.setVerticalGroup(formLayout.createSequentialGroup().addComponent(companyNameField).addGroup(formLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addGap(10).addGroup(formLayout.createSequentialGroup().addComponent(currentLabel).addComponent(previousLabel)).addGap(10).addGroup(formLayout.createSequentialGroup().addComponent(this.currentField).addComponent(this.previousField))));
    }

    public void updateCompany() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CompanyPanel.this.currentField.setText(CompanyPanel.this.format.format(CompanyPanel.this.model.getCurrentPrice()));
                CompanyPanel.this.previousField.setText(CompanyPanel.this.format.format(CompanyPanel.this.model.getPreviousPrice()));
                if (CompanyPanel.this.model.getCurrentPrice() > CompanyPanel.this.model.getPreviousPrice()) {
                    CompanyPanel.this.currentField.setForeground(Color.BLUE);
                } else {
                    CompanyPanel.this.currentField.setForeground(Color.RED);
                }
            }
        });
    }
}

