/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder;

import java.util.HashMap;
import org.drools.compiler.lang.descr.ActionDescr;
import org.drools.compiler.lang.descr.ProcessDescr;
import org.jbpm.process.builder.ExtendedNodeBuilder;
import org.jbpm.process.builder.ProcessBuildContext;
import org.jbpm.process.builder.dialect.ProcessDialect;
import org.jbpm.process.builder.dialect.ProcessDialectRegistry;
import org.jbpm.process.core.ContextResolver;
import org.jbpm.process.core.impl.DataTransformerRegistry;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.Transformation;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.process.DataTransformer;

public class ActionNodeBuilder
extends ExtendedNodeBuilder {
    @Override
    public void build(Process process, ProcessDescr processDescr, ProcessBuildContext context, Node node) {
        Transformation transformation;
        super.build(process, processDescr, context, node);
        ActionNode actionNode = (ActionNode)node;
        if (actionNode.getAction() instanceof DroolsConsequenceAction) {
            DroolsConsequenceAction action = (DroolsConsequenceAction)actionNode.getAction();
            ActionDescr actionDescr = new ActionDescr();
            actionDescr.setText(action.getConsequence());
            actionDescr.setResource(processDescr.getResource());
            ProcessDialect dialect = ProcessDialectRegistry.getDialect(action.getDialect());
            dialect.getActionBuilder().build(context, (DroolsAction)action, actionDescr, (ContextResolver)((NodeImpl)node));
        }
        if ((transformation = (Transformation)node.getMetaData().get("Transformation")) != null) {
            WorkflowProcess wfProcess = (WorkflowProcess)process;
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("imports", wfProcess.getImports());
            parameters.put("classloader", context.getConfiguration().getClassLoader());
            DataTransformer transformer = DataTransformerRegistry.get().find(transformation.getLanguage());
            transformation.setCompiledExpression(transformer.compile(transformation.getExpression(), parameters));
        }
    }
}

