/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class DropDownMenuWithDefaultAction
extends Action
implements IMenuCreator {
    private Menu dropDownMenu;
    private IAction delegate;
    private List list;
    private IPropertyChangeListener enabledListener;
    private SelectionListener selectionListener = new ItemSelectionListener(this);

    public DropDownMenuWithDefaultAction(IAction action) {
        this.setMenuCreator(this);
        this.dropDownMenu = null;
        this.setAction(action);
        this.list = new ArrayList();
    }

    public void dispose() {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
            this.dropDownMenu = null;
        }
    }

    public void add(IContributionItem item) {
        this.list.add(item);
    }

    public void add(IAction action) {
        this.list.add(action);
    }

    public Menu getMenu(Control parent) {
        if (this.dropDownMenu == null) {
            this.dropDownMenu = new Menu(parent);
            this.populateMenu();
        }
        return this.dropDownMenu;
    }

    public Menu getMenu(Menu parent) {
        if (this.dropDownMenu == null) {
            this.dropDownMenu = new Menu(parent);
            this.populateMenu();
        }
        return this.dropDownMenu;
    }

    private void populateMenu() {
        for (Object object : this.list) {
            if (object instanceof IContributionItem) {
                IContributionItem item = (IContributionItem)object;
                item.fill(this.dropDownMenu, -1);
                continue;
            }
            IAction action = (IAction)object;
            ActionContributionItem item = new ActionContributionItem(action);
            item.fill(this.dropDownMenu, -1);
        }
        MenuItem[] items = this.dropDownMenu.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].addSelectionListener(this.selectionListener);
            ++i;
        }
    }

    public void setAction(IAction action) {
        if (this.enabledListener == null) {
            this.enabledListener = new EnabledPropertyChangeListener((IAction)this);
        }
        this.setText(action.getText());
        this.setToolTipText(action.getToolTipText());
        this.setImageDescriptor(action.getImageDescriptor());
        this.setDisabledImageDescriptor(action.getDisabledImageDescriptor());
        this.setEnabled(action.isEnabled());
        this.setDescription(action.getDescription());
        this.setHelpListener(action.getHelpListener());
        this.setHoverImageDescriptor(action.getHoverImageDescriptor());
        if (this.delegate != null) {
            this.delegate.removePropertyChangeListener(this.enabledListener);
        }
        this.delegate = action;
        this.delegate.addPropertyChangeListener(this.enabledListener);
    }

    public void run() {
        this.delegate.run();
    }

    public static class EnabledPropertyChangeListener
    implements IPropertyChangeListener {
        private IAction action;

        public EnabledPropertyChangeListener(IAction action) {
            this.action = action;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("enabled")) {
                this.action.setEnabled(((Boolean)event.getNewValue()).booleanValue());
            }
        }
    }

    public static class ItemSelectionListener
    implements SelectionListener {
        private DropDownMenuWithDefaultAction dropDownMenu;

        public ItemSelectionListener(DropDownMenuWithDefaultAction dropDownMenu) {
            this.dropDownMenu = dropDownMenu;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            MenuItem menuItem = (MenuItem)e.getSource();
            if (menuItem.getData() instanceof ActionContributionItem) {
                ActionContributionItem item = (ActionContributionItem)menuItem.getData();
                this.dropDownMenu.setAction(item.getAction());
            }
        }

        public void widgetSelected(SelectionEvent e) {
            MenuItem menuItem = (MenuItem)e.getSource();
            if (menuItem.getData() instanceof ActionContributionItem) {
                ActionContributionItem item = (ActionContributionItem)menuItem.getData();
                this.dropDownMenu.setAction(item.getAction());
            }
        }
    }
}

